"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateGapsBatch = void 0;
var _apmUtils = require("@kbn/apm-utils");
var _utils = require("./utils");
var _update_gaps_in_event_log = require("./update_gaps_in_event_log");
var _apply_scheduled_backfills_to_gap = require("./apply_scheduled_backfills_to_gap");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateGapsBatch = async ({
  gaps,
  backfillSchedule,
  savedObjectsRepository,
  shouldRefetchAllBackfills,
  backfillClient,
  actionsClient,
  alertingEventLogger,
  logger,
  ruleId,
  eventLogClient
}) => {
  const prepareGaps = async gapsToUpdate => {
    const scheduledItems = (backfillSchedule !== null && backfillSchedule !== void 0 ? backfillSchedule : []).map(backfill => {
      try {
        return (0, _utils.toScheduledItem)(backfill);
      } catch (error) {
        logger.error(`Error processing a scheduled item while updating gaps: ${error.message}`);
        return undefined;
      }
    }).filter(scheduledItem => scheduledItem !== undefined);
    await (0, _apmUtils.withSpan)({
      name: 'updateGaps.prepareGapsForUpdate',
      type: 'rule'
    }, async () => {
      for (const {
        gap,
        scheduled
      } of (0, _utils.findOverlappingIntervals)(gapsToUpdate, scheduledItems)) {
        // we do async request only if there errors in backfill or no backfill schedule
        await (0, _apply_scheduled_backfills_to_gap.applyScheduledBackfillsToGap)({
          gap,
          scheduledItems: scheduled,
          savedObjectsRepository,
          shouldRefetchAllBackfills,
          logger,
          backfillClient,
          actionsClient,
          ruleId
        });
      }
    });
    // Convert gaps to the format expected by updateDocuments
    return gapsToUpdate.map(gap => {
      if (!gap.internalFields) return null;
      return {
        gap: gap.toObject(),
        internalFields: gap.internalFields
      };
    }).filter(gap => gap !== null);
  };
  return (0, _update_gaps_in_event_log.updateGapsInEventLog)({
    gaps,
    prepareGaps,
    eventLogClient,
    alertingEventLogger,
    logger
  });
};
exports.updateGapsBatch = updateGapsBatch;