"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSystemActionKibanaPrivileges = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSystemActionKibanaPrivileges = ({
  connectorAdapterRegistry,
  systemActions = [],
  rule
}) => {
  const kibanaPrivileges = systemActions.filter(action => connectorAdapterRegistry.has(action.actionTypeId)).map(action => connectorAdapterRegistry.get(action.actionTypeId)).map(adapter => {
    var _adapter$getKibanaPri, _adapter$getKibanaPri2;
    return (_adapter$getKibanaPri = (_adapter$getKibanaPri2 = adapter.getKibanaPrivileges) === null || _adapter$getKibanaPri2 === void 0 ? void 0 : _adapter$getKibanaPri2.call(adapter, {
      consumer: rule.consumer,
      producer: rule.producer
    })) !== null && _adapter$getKibanaPri !== void 0 ? _adapter$getKibanaPri : [];
  }).flat();
  return Array.from(new Set(kibanaPrivileges));
};
exports.getSystemActionKibanaPrivileges = getSystemActionKibanaPrivileges;