"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkDeleteRulesRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkDeleteRulesRequestBodySchema = exports.bulkDeleteRulesRequestBodySchema = _configSchema.schema.object({
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1,
    maxSize: 1000
  })),
  ignoreInternalRuleTypes: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true
  }))
});