"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maintenanceWindowsStatusSchema = exports.findMaintenanceWindowsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maintenanceWindowsStatusSchema = exports.maintenanceWindowsStatusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('running'), _configSchema.schema.literal('finished'), _configSchema.schema.literal('upcoming'), _configSchema.schema.literal('archived'), _configSchema.schema.literal('disabled')]);
const findMaintenanceWindowsParamsSchema = exports.findMaintenanceWindowsParamsSchema = _configSchema.schema.object({
  status: _configSchema.schema.maybe(_configSchema.schema.arrayOf(maintenanceWindowsStatusSchema)),
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  searchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  perPage: _configSchema.schema.maybe(_configSchema.schema.number()),
  page: _configSchema.schema.maybe(_configSchema.schema.number())
});