"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sanitizeBulkErrorResponse = void 0;
var _lodash = require("lodash");
var _saferLodashSet = require("@kbn/safer-lodash-set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sanitizeBulkErrorResponse = response => {
  const clonedResponse = (0, _lodash.cloneDeep)(response);
  const isTransportResponse = !!response.body;
  const responseToUse = isTransportResponse ? clonedResponse.body : clonedResponse;
  if (responseToUse.errors) {
    var _responseToUse$items;
    ((_responseToUse$items = responseToUse.items) !== null && _responseToUse$items !== void 0 ? _responseToUse$items : []).forEach(item => {
      for (const [_, responseItem] of Object.entries(item)) {
        const reason = (0, _lodash.get)(responseItem, 'error.reason');
        const redactIndex = reason ? reason.indexOf(`Preview of field's value:`) : -1;
        if (redactIndex > 1) {
          (0, _saferLodashSet.set)(responseItem, 'error.reason', reason.substring(0, redactIndex - 1));
        }
      }
    });
  }
  return clonedResponse;
};
exports.sanitizeBulkErrorResponse = sanitizeBulkErrorResponse;