"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS_SORT = exports.STATUS_OPTIONS = exports.STATUS_DISPLAY = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _common = require("../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_DISPLAY = exports.STATUS_DISPLAY = {
  [_common.MaintenanceWindowStatus.Running]: {
    color: 'primary',
    label: i18n.TABLE_STATUS_RUNNING
  },
  [_common.MaintenanceWindowStatus.Upcoming]: {
    color: 'warning',
    label: i18n.TABLE_STATUS_UPCOMING
  },
  [_common.MaintenanceWindowStatus.Finished]: {
    color: 'success',
    label: i18n.TABLE_STATUS_FINISHED
  },
  [_common.MaintenanceWindowStatus.Archived]: {
    color: 'default',
    label: i18n.TABLE_STATUS_ARCHIVED
  },
  [_common.MaintenanceWindowStatus.Disabled]: {
    color: 'default',
    label: i18n.TABLE_STATUS_DISABLED
  }
};
const STATUS_SORT = exports.STATUS_SORT = {
  [_common.MaintenanceWindowStatus.Running]: 0,
  [_common.MaintenanceWindowStatus.Upcoming]: 1,
  [_common.MaintenanceWindowStatus.Finished]: 2,
  [_common.MaintenanceWindowStatus.Archived]: 3,
  [_common.MaintenanceWindowStatus.Disabled]: 4
};
const STATUS_OPTIONS = exports.STATUS_OPTIONS = [{
  value: _common.MaintenanceWindowStatus.Running,
  name: i18n.TABLE_STATUS_RUNNING
}, {
  value: _common.MaintenanceWindowStatus.Upcoming,
  name: i18n.TABLE_STATUS_UPCOMING
}, {
  value: _common.MaintenanceWindowStatus.Finished,
  name: i18n.TABLE_STATUS_FINISHED
}, {
  value: _common.MaintenanceWindowStatus.Archived,
  name: i18n.TABLE_STATUS_ARCHIVED
}, {
  value: _common.MaintenanceWindowStatus.Disabled,
  name: i18n.TABLE_STATUS_DISABLED
}];