"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateBulkDeleteRulesBody = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateBulkDeleteRulesBody = options => {
  const filter = options.filter;
  const ids = options.ids;
  if (!ids && !filter) {
    throw _boom.default.badRequest("Either 'ids' or 'filter' property in method's arguments should be provided");
  }
  if ((ids === null || ids === void 0 ? void 0 : ids.length) === 0) {
    throw _boom.default.badRequest("'ids' property should not be an empty array");
  }
  if (ids && filter) {
    throw _boom.default.badRequest("Both 'filter' and 'ids' are supplied. Define either 'ids' or 'filter' properties in method's arguments");
  }
};
exports.validateBulkDeleteRulesBody = validateBulkDeleteRulesBody;