"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertDeleteScheduleQuerySchema = exports.alertDeletePreviewResponseSchema = exports.alertDeletePreviewQuerySchema = exports.alertDeleteLastRunResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ALERT_DELETE_THRESHOLD_DAYS = 3 * 365; // 3 years
const MIN_ALERT_DELETE_THRESHOLD_DAYS = 1;
const alertDeleteSettingsSchema = {
  active_alert_delete_threshold: _configSchema.schema.maybe(_configSchema.schema.number({
    min: MIN_ALERT_DELETE_THRESHOLD_DAYS,
    max: MAX_ALERT_DELETE_THRESHOLD_DAYS,
    meta: {
      description: 'Threshold (in days) for deleting active alerts older than this value'
    }
  })),
  inactive_alert_delete_threshold: _configSchema.schema.maybe(_configSchema.schema.number({
    min: MIN_ALERT_DELETE_THRESHOLD_DAYS,
    max: MAX_ALERT_DELETE_THRESHOLD_DAYS,
    meta: {
      description: 'Threshold (in days) for deleting inactive alerts (recovered/closed/untracked) older than this value'
    }
  })),
  category_ids: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.alertDeleteCategoryIds.SECURITY_SOLUTION), _configSchema.schema.literal(_constants.alertDeleteCategoryIds.OBSERVABILITY), _configSchema.schema.literal(_constants.alertDeleteCategoryIds.MANAGEMENT)]), {
    minSize: 1
  }), _configSchema.schema.literal(_constants.alertDeleteCategoryIds.SECURITY_SOLUTION), _configSchema.schema.literal(_constants.alertDeleteCategoryIds.OBSERVABILITY), _configSchema.schema.literal(_constants.alertDeleteCategoryIds.MANAGEMENT)], {
    meta: {
      description: 'Solutions to delete alerts from'
    }
  })
};
const alertDeletePreviewQuerySchema = exports.alertDeletePreviewQuerySchema = _configSchema.schema.object(alertDeleteSettingsSchema);
const alertDeletePreviewResponseSchema = exports.alertDeletePreviewResponseSchema = _configSchema.schema.object({
  affected_alert_count: _configSchema.schema.number()
});
const alertDeleteScheduleQuerySchema = exports.alertDeleteScheduleQuerySchema = _configSchema.schema.object({
  ...alertDeleteSettingsSchema,
  space_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1,
    meta: {
      description: 'Kibana space IDs to delete alerts from'
    }
  }))
});
const alertDeleteLastRunResponseSchema = exports.alertDeleteLastRunResponseSchema = _configSchema.schema.object({
  last_run: _configSchema.schema.maybe(_configSchema.schema.string())
});