"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateBackfillSchedule = validateBackfillSchedule;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateBackfillSchedule(start, end) {
  try {
    const now = new Date().valueOf();
    const parsedStart = Date.parse(start);
    if (isNaN(parsedStart)) {
      return `Backfill start must be valid date`;
    }
    if (now - parsedStart > _constants.MAX_SCHEDULE_BACKFILL_LOOKBACK_WINDOW_MS) {
      return `Backfill cannot look back more than ${_constants.MAX_SCHEDULE_BACKFILL_LOOKBACK_WINDOW_DAYS} days`;
    }
    if (now < parsedStart) {
      return `Backfill cannot be scheduled for the future`;
    }
    if (end) {
      const parsedEnd = Date.parse(end);
      if (isNaN(parsedEnd)) {
        return `Backfill end must be valid date`;
      }
      const startMs = new Date(start).valueOf();
      const endMs = new Date(end).valueOf();
      if (endMs <= startMs) {
        return `Backfill end must be greater than backfill start`;
      }
      if (now < parsedEnd) {
        return `Backfill cannot be scheduled for the future`;
      }
    }
  } catch (err) {
    return `Error validating backfill schedule - ${err.message}`;
  }
}