"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisEmbeddableInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _time_field_warning = require("../../components/time_field_warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/embeddables/log_rate_analysis/log_rate_analysis_embeddable_initializer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogRateAnalysisEmbeddableInitializer = ({
  dataViews,
  IndexPatternSelect,
  initialInput,
  onCreate,
  onCancel,
  onPreview,
  isNewPanel
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isMounted = (0, _useMountedState.default)();
  const [formInput, setFormInput] = (0, _react.useState)((0, _lodash.pick)(initialInput !== null && initialInput !== void 0 ? initialInput : {}, ['dataViewId']));

  // State to track if the selected data view is time based, undefined is used
  // to track that the check is in progress.
  const [isDataViewTimeBased, setIsDataViewTimeBased] = (0, _react.useState)();
  const isFormValid = (0, _react.useMemo)(() => (0, _mlIsPopulatedObject.isPopulatedObject)(formInput, ['dataViewId']) && formInput.dataViewId !== '' && isDataViewTimeBased === true, [formInput, isDataViewTimeBased]);
  const updatedProps = (0, _react.useMemo)(() => {
    return {
      ...formInput,
      title: (0, _mlIsPopulatedObject.isPopulatedObject)(formInput) ? _i18n.i18n.translate('xpack.aiops.embeddableLogRateAnalysis.attachmentTitle', {
        defaultMessage: 'Log rate analysis'
      }) : ''
    };
  }, [formInput]);
  (0, _react.useEffect)(function previewChanges() {
    if (isFormValid) {
      onPreview(updatedProps);
    }
  }, [isFormValid, onPreview, updatedProps, isDataViewTimeBased]);
  const setDataViewId = (0, _react.useCallback)(dataViewId => {
    setFormInput({
      ...formInput,
      dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : ''
    });
    setIsDataViewTimeBased(undefined);
  }, [formInput]);
  (0, _react.useEffect)(function checkIsDataViewTimeBased() {
    setIsDataViewTimeBased(undefined);
    const {
      dataViewId
    } = formInput;
    if (!dataViewId) {
      return;
    }
    dataViews.get(dataViewId).then(dataView => {
      if (!isMounted()) {
        return;
      }
      setIsDataViewTimeBased(dataView.isTimeBased());
    }).catch(() => {
      setIsDataViewTimeBased(undefined);
    });
  }, [dataViews, formInput, isMounted]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    css: {
      pointerEvents: 'auto',
      backgroundColor: euiTheme.colors.emptyShade
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "inlineEditingFlyoutLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "logRateAnalysisConfig",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, isNewPanel ? _i18n.i18n.translate('xpack.aiops.embeddableLogRateAnalysis.config.title.new', {
    defaultMessage: 'Create log rate analysis'
  }) : _i18n.i18n.translate('xpack.aiops.embeddableLogRateAnalysis.config.title.edit', {
    defaultMessage: 'Edit log rate analysis'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "aiopsLogRateAnalysisControls",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.aiops.embeddableLogRateAnalysis.config.dataViewLabel', {
      defaultMessage: 'Data view'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
    autoFocus: !formInput.dataViewId,
    fullWidth: true,
    compressed: true,
    indexPatternId: formInput.dataViewId,
    placeholder: _i18n.i18n.translate('xpack.aiops.embeddableLogRateAnalysis.config.dataViewSelectorPlaceholder', {
      defaultMessage: 'Select data view'
    }),
    onChange: newId => {
      setDataViewId(newId !== null && newId !== void 0 ? newId : '');
    },
    "data-test-subj": "aiopsLogRateAnalysisEmbeddableDataViewSelector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }), isDataViewTimeBased === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_time_field_warning.TimeFieldWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    size: "m",
    onClick: onCancel,
    "data-test-subj": "aiopsLogRateAnalysisCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableLogRateAnalysis.config.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onCreate.bind(null, updatedProps),
    fill: true,
    "aria-label": _i18n.i18n.translate('xpack.aiops.embeddableLogRateAnalysis.config.applyFlyoutAriaLabel', {
      defaultMessage: 'Apply changes'
    }),
    isDisabled: !isFormValid,
    iconType: "check",
    "data-test-subj": "aiopsLogRateAnalysisConfirmButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableLogRateAnalysis.config.applyAndCloseLabel",
    defaultMessage: "Apply and close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 15
    }
  }))))));
};
exports.LogRateAnalysisEmbeddableInitializer = LogRateAnalysisEmbeddableInitializer;