"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActions = useActions;
var _react = require("react");
var _get_category_query = require("@kbn/aiops-log-pattern-analysis/get_category_query");
var _use_open_in_discover = require("./use_open_in_discover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useActions(dataViewId, selectedField, selectedCategories, aiopsListState, timefilter, onAddFilter, additionalFilter, onClose = () => {}) {
  const openInDiscover = (0, _use_open_in_discover.useOpenInDiscover)(dataViewId, selectedField !== null && selectedField !== void 0 ? selectedField : undefined, selectedCategories, aiopsListState, timefilter, onAddFilter, additionalFilter);
  const {
    getLabels: getOpenInDiscoverLabels,
    openFunction: openInDiscoverFunction
  } = openInDiscover;
  const getActions = (0, _react.useCallback)(navigateToDiscover => {
    const openInDiscoverLabels = getOpenInDiscoverLabels(navigateToDiscover);
    return [{
      name: openInDiscoverLabels.singleSelect.in,
      description: openInDiscoverLabels.singleSelect.in,
      icon: 'plusInCircle',
      type: 'icon',
      'data-test-subj': 'aiopsLogPatternsActionFilterInButton',
      onClick: category => openInDiscoverFunction(_get_category_query.QUERY_MODE.INCLUDE, navigateToDiscover, category)
    }, {
      name: openInDiscoverLabels.singleSelect.out,
      description: openInDiscoverLabels.singleSelect.out,
      icon: 'minusInCircle',
      type: 'icon',
      'data-test-subj': 'aiopsLogPatternsActionFilterOutButton',
      onClick: category => openInDiscoverFunction(_get_category_query.QUERY_MODE.EXCLUDE, navigateToDiscover, category)
    }];
  }, [getOpenInDiscoverLabels, openInDiscoverFunction]);
  return {
    getActions,
    openInDiscover
  };
}