"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsPopover = FieldStatsPopover;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _field_popover = require("@kbn/unified-field-list/src/components/field_popover");
var _field_stats_content = require("./field_stats_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/field_stats_popover/field_stats_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldStatsPopover({
  dataView,
  dslQuery,
  fieldName,
  fieldValue,
  fieldStatsServices,
  timeRangeMs
}) {
  const [infoIsOpen, setInfoOpen] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const closePopover = (0, _react.useCallback)(() => setInfoOpen(false), []);
  const fieldForStats = (0, _react.useMemo)(() => (0, _mlIsDefined.isDefined)(fieldName) ? dataView.getFieldByName(fieldName) : undefined, [fieldName, dataView]);
  const trigger = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.aiops.fieldContextPopover.descriptionTooltipContent', {
      defaultMessage: 'Show top field values'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "inspect",
    onClick: ev => {
      setInfoOpen(!infoIsOpen);
    },
    "aria-label": _i18n.i18n.translate('xpack.aiops.fieldContextPopover.topFieldValuesAriaLabel', {
      defaultMessage: 'Show top field values for {fieldName}',
      values: {
        fieldName
      }
    }),
    "data-test-subj": 'aiopsContextPopoverButton',
    css: {
      marginLeft: euiTheme.size.xs
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
  if (!fieldForStats) return null;
  return /*#__PURE__*/_react.default.createElement(_field_popover.FieldPopover, {
    isOpen: infoIsOpen,
    closePopover: closePopover,
    button: trigger,
    renderHeader: () => /*#__PURE__*/_react.default.createElement(_field_popover.FieldPopoverHeader, {
      field: fieldForStats,
      closePopover: closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 27
      }
    }),
    renderContent: () => /*#__PURE__*/_react.default.createElement(_field_stats_content.FieldStatsContent, {
      field: fieldForStats,
      fieldName: fieldName,
      fieldValue: fieldValue,
      dataView: dataView,
      fieldStatsServices: fieldStatsServices,
      timeRangeMs: timeRangeMs,
      dslQuery: dslQuery,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  });
}