"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionTaskParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionTaskParamsSchema = exports.actionTaskParamsSchema = _configSchema.schema.object({
  actionId: _configSchema.schema.string(),
  executionId: _configSchema.schema.maybe(_configSchema.schema.string()),
  apiKey: _configSchema.schema.nullable(_configSchema.schema.string()),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()), {
    defaultValue: {}
  }),
  consumer: _configSchema.schema.maybe(_configSchema.schema.string()),
  source: _configSchema.schema.maybe(_configSchema.schema.string()),
  relatedSavedObjects: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    namespace: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1
    })),
    id: _configSchema.schema.string({
      minLength: 1
    }),
    type: _configSchema.schema.string({
      minLength: 1
    }),
    // optional; for SO types like action/alert that have type id's
    typeId: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1
    }))
  }), {
    defaultValue: []
  }))
});