"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectBase = injectBase;
const reflect_metadata_utils_1 = require("@inversifyjs/reflect-metadata-utils");
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const classMetadataReflectKey_1 = require("../../reflectMetadata/data/classMetadataReflectKey");
const updateMaybeClassMetadataConstructorArgument_1 = require("../actions/updateMaybeClassMetadataConstructorArgument");
const updateMaybeClassMetadataProperty_1 = require("../actions/updateMaybeClassMetadataProperty");
const getDefaultClassMetadata_1 = require("../calculations/getDefaultClassMetadata");
const handleInjectionError_1 = require("../calculations/handleInjectionError");
function injectBase(updateMetadata, updatePendingClassMetadataCount) {
    const decorator = (target, propertyKey, parameterIndexOrDescriptor) => {
        try {
            if (parameterIndexOrDescriptor === undefined) {
                injectProperty(updateMetadata, updatePendingClassMetadataCount)(target, propertyKey);
            }
            else {
                if (typeof parameterIndexOrDescriptor === 'number') {
                    injectParameter(updateMetadata, updatePendingClassMetadataCount)(target, propertyKey, parameterIndexOrDescriptor);
                }
                else {
                    injectMethod(updateMetadata, updatePendingClassMetadataCount)(target, propertyKey, parameterIndexOrDescriptor);
                }
            }
        }
        catch (error) {
            (0, handleInjectionError_1.handleInjectionError)(target, propertyKey, parameterIndexOrDescriptor, error);
        }
    };
    return decorator;
}
function buildComposedUpdateMetadata(updateMetadata, updatePendingClassMetadataCount) {
    return (target) => {
        const updateTargetPendingClassMetadataCount = updatePendingClassMetadataCount(target);
        return (metadata) => {
            updateTargetPendingClassMetadataCount(metadata);
            return updateMetadata(metadata);
        };
    };
}
function injectMethod(updateMetadata, updatePendingClassMetadataCount) {
    const buildComposedUpdateMetadataFromTarget = buildComposedUpdateMetadata(updateMetadata, updatePendingClassMetadataCount);
    return (target, propertyKey, descriptor) => {
        if (isPropertySetter(descriptor)) {
            (0, reflect_metadata_utils_1.updateOwnReflectMetadata)(target.constructor, classMetadataReflectKey_1.classMetadataReflectKey, getDefaultClassMetadata_1.getDefaultClassMetadata, (0, updateMaybeClassMetadataProperty_1.updateMaybeClassMetadataProperty)(buildComposedUpdateMetadataFromTarget(target), propertyKey));
        }
        else {
            throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.injectionDecoratorConflict, `Found an @inject decorator in a non setter property method.
Found @inject decorator at method "${propertyKey.toString()}" at class "${target.constructor.name}"`);
        }
    };
}
function injectParameter(updateMetadata, updatePendingClassMetadataCount) {
    const buildComposedUpdateMetadataFromTarget = buildComposedUpdateMetadata(updateMetadata, updatePendingClassMetadataCount);
    return (target, propertyKey, parameterIndex) => {
        if (isConstructorParameter(target, propertyKey)) {
            (0, reflect_metadata_utils_1.updateOwnReflectMetadata)(target, classMetadataReflectKey_1.classMetadataReflectKey, getDefaultClassMetadata_1.getDefaultClassMetadata, (0, updateMaybeClassMetadataConstructorArgument_1.updateMaybeClassMetadataConstructorArgument)(buildComposedUpdateMetadataFromTarget(target), parameterIndex));
        }
        else {
            throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.injectionDecoratorConflict, `Found an @inject decorator in a non constructor parameter.
Found @inject decorator at method "${propertyKey?.toString() ?? ''}" at class "${target.constructor.name}"`);
        }
    };
}
function injectProperty(updateMetadata, updatePendingClassMetadataCount) {
    const buildComposedUpdateMetadataFromTarget = buildComposedUpdateMetadata(updateMetadata, updatePendingClassMetadataCount);
    return (target, propertyKey) => {
        (0, reflect_metadata_utils_1.updateOwnReflectMetadata)(target.constructor, classMetadataReflectKey_1.classMetadataReflectKey, getDefaultClassMetadata_1.getDefaultClassMetadata, (0, updateMaybeClassMetadataProperty_1.updateMaybeClassMetadataProperty)(buildComposedUpdateMetadataFromTarget(target), propertyKey));
    };
}
function isConstructorParameter(target, propertyKey) {
    return typeof target === 'function' && propertyKey === undefined;
}
function isPropertySetter(descriptor) {
    return descriptor.set !== undefined;
}
//# sourceMappingURL=injectBase.js.map