"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buttons = void 0;
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _hex_to_rgb = require("../../../../services/color/hex_to_rgb");
var _is_color_dark = require("../../../../services/color/is_color_dark");
var _manipulation = require("../../../../services/color/manipulation");
var _colors_severity = require("./_colors_severity");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var isDark = function isDark(background) {
  return background ? _is_color_dark.isColorDark.apply(void 0, _toConsumableArray((0, _hex_to_rgb.hexToRgb)(background))) : false;
};
var _buttons = {
  backgroundPrimary: (0, _euiThemeCommon.computed)(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
      backgroundLightPrimary = _ref2[0];
    return backgroundLightPrimary;
  }, ['colors.backgroundLightPrimary']),
  backgroundAccent: (0, _euiThemeCommon.computed)(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 1),
      backgroundLightAccent = _ref4[0];
    return backgroundLightAccent;
  }, ['colors.backgroundLightAccent']),
  backgroundAccentSecondary: (0, _euiThemeCommon.computed)(function (_ref5) {
    var _ref6 = _slicedToArray(_ref5, 1),
      backgroundLightAccentSecondary = _ref6[0];
    return backgroundLightAccentSecondary;
  }, ['colors.backgroundLightAccentSecondary']),
  backgroundNeutral: (0, _euiThemeCommon.computed)(function (_ref7) {
    var _ref8 = _slicedToArray(_ref7, 1),
      backgroundLightNeutral = _ref8[0];
    return backgroundLightNeutral;
  }, ['colors.backgroundLightNeutral']),
  backgroundSuccess: (0, _euiThemeCommon.computed)(function (_ref9) {
    var _ref10 = _slicedToArray(_ref9, 1),
      backgroundLightSuccess = _ref10[0];
    return backgroundLightSuccess;
  }, ['colors.backgroundLightSuccess']),
  backgroundWarning: (0, _euiThemeCommon.computed)(function (_ref11) {
    var _ref12 = _slicedToArray(_ref11, 1),
      backgroundLightWarning = _ref12[0];
    return backgroundLightWarning;
  }, ['colors.backgroundLightWarning']),
  backgroundRisk: (0, _euiThemeCommon.computed)(function (_ref13) {
    var _ref14 = _slicedToArray(_ref13, 1),
      backgroundLightRisk = _ref14[0];
    return backgroundLightRisk;
  }, ['colors.backgroundLightRisk']),
  backgroundDanger: (0, _euiThemeCommon.computed)(function (_ref15) {
    var _ref16 = _slicedToArray(_ref15, 1),
      backgroundLightDanger = _ref16[0];
    return backgroundLightDanger;
  }, ['colors.backgroundLightDanger']),
  backgroundText: (0, _euiThemeCommon.computed)(function (_ref17) {
    var _ref18 = _slicedToArray(_ref17, 1),
      backgroundLightText = _ref18[0];
    return backgroundLightText;
  }, ['colors.backgroundLightText']),
  backgroundDisabled: (0, _euiThemeCommon.computed)(function (_ref19) {
    var _ref20 = _slicedToArray(_ref19, 1),
      lightShade = _ref20[0];
    return (0, _manipulation.transparentize)(lightShade, 0.15);
  }, ['colors.lightShade']),
  backgroundPrimaryHover: (0, _euiThemeCommon.computed)(function (_ref21) {
    var _ref22 = _slicedToArray(_ref21, 1),
      primary = _ref22[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  backgroundAccentHover: (0, _euiThemeCommon.computed)(function (_ref23) {
    var _ref24 = _slicedToArray(_ref23, 1),
      accent = _ref24[0];
    return (0, _manipulation.transparentize)(accent, 0.1);
  }, ['colors.accent']),
  backgroundAccentSecondaryHover: (0, _euiThemeCommon.computed)(function (_ref25) {
    var _ref26 = _slicedToArray(_ref25, 1),
      success = _ref26[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundNeutralHover: (0, _manipulation.transparentize)(_colors_severity.severityColors.neutral, 0.1),
  backgroundSuccessHover: (0, _euiThemeCommon.computed)(function (_ref27) {
    var _ref28 = _slicedToArray(_ref27, 1),
      success = _ref28[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundWarningHover: (0, _euiThemeCommon.computed)(function (_ref29) {
    var _ref30 = _slicedToArray(_ref29, 1),
      warning = _ref30[0];
    return (0, _manipulation.transparentize)(warning, 0.1);
  }, ['colors.warning']),
  backgroundRiskHover: (0, _manipulation.transparentize)(_colors_severity.severityColors.risk, 0.1),
  backgroundDangerHover: (0, _euiThemeCommon.computed)(function (_ref31) {
    var _ref32 = _slicedToArray(_ref31, 1),
      danger = _ref32[0];
    return (0, _manipulation.transparentize)(danger, 0.1);
  }, ['colors.danger']),
  backgroundTextHover: (0, _euiThemeCommon.computed)(function (_ref33) {
    var _ref34 = _slicedToArray(_ref33, 1),
      lightShade = _ref34[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  backgroundPrimaryActive: (0, _euiThemeCommon.computed)(function (_ref35) {
    var _ref36 = _slicedToArray(_ref35, 1),
      primary = _ref36[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  backgroundAccentActive: (0, _euiThemeCommon.computed)(function (_ref37) {
    var _ref38 = _slicedToArray(_ref37, 1),
      accent = _ref38[0];
    return (0, _manipulation.transparentize)(accent, 0.1);
  }, ['colors.accent']),
  backgroundAccentSecondaryActive: (0, _euiThemeCommon.computed)(function (_ref39) {
    var _ref40 = _slicedToArray(_ref39, 1),
      success = _ref40[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundNeutralActive: (0, _manipulation.transparentize)(_colors_severity.severityColors.neutral, 0.1),
  backgroundSuccessActive: (0, _euiThemeCommon.computed)(function (_ref41) {
    var _ref42 = _slicedToArray(_ref41, 1),
      success = _ref42[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundWarningActive: (0, _euiThemeCommon.computed)(function (_ref43) {
    var _ref44 = _slicedToArray(_ref43, 1),
      warning = _ref44[0];
    return (0, _manipulation.transparentize)(warning, 0.1);
  }, ['colors.warning']),
  backgroundRiskActive: (0, _manipulation.transparentize)(_colors_severity.severityColors.risk, 0.1),
  backgroundDangerActive: (0, _euiThemeCommon.computed)(function (_ref45) {
    var _ref46 = _slicedToArray(_ref45, 1),
      danger = _ref46[0];
    return (0, _manipulation.transparentize)(danger, 0.1);
  }, ['colors.danger']),
  backgroundTextActive: (0, _euiThemeCommon.computed)(function (_ref47) {
    var _ref48 = _slicedToArray(_ref47, 1),
      lightShade = _ref48[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  backgroundFilledPrimary: (0, _euiThemeCommon.computed)(function (_ref49) {
    var _ref50 = _slicedToArray(_ref49, 1),
      backgroundFilledPrimary = _ref50[0];
    return backgroundFilledPrimary;
  }, ['colors.backgroundFilledPrimary']),
  backgroundFilledAccent: (0, _euiThemeCommon.computed)(function (_ref51) {
    var _ref52 = _slicedToArray(_ref51, 1),
      backgroundFilledAccent = _ref52[0];
    return backgroundFilledAccent;
  }, ['colors.backgroundFilledAccent']),
  backgroundFilledAccentSecondary: (0, _euiThemeCommon.computed)(function (_ref53) {
    var _ref54 = _slicedToArray(_ref53, 1),
      backgroundFilledAccent = _ref54[0];
    return backgroundFilledAccent;
  }, ['colors.backgroundFilledAccent']),
  backgroundFilledNeutral: (0, _euiThemeCommon.computed)(function (_ref55) {
    var _ref56 = _slicedToArray(_ref55, 1),
      backgroundFilledNeutral = _ref56[0];
    return backgroundFilledNeutral;
  }, ['colors.backgroundFilledNeutral']),
  backgroundFilledSuccess: (0, _euiThemeCommon.computed)(function (_ref57) {
    var _ref58 = _slicedToArray(_ref57, 1),
      backgroundFilledSuccess = _ref58[0];
    return backgroundFilledSuccess;
  }, ['colors.backgroundFilledSuccess']),
  backgroundFilledWarning: (0, _euiThemeCommon.computed)(function (_ref59) {
    var _ref60 = _slicedToArray(_ref59, 1),
      backgroundFilledWarning = _ref60[0];
    return backgroundFilledWarning;
  }, ['colors.backgroundFilledWarning']),
  backgroundFilledRisk: (0, _euiThemeCommon.computed)(function (_ref61) {
    var _ref62 = _slicedToArray(_ref61, 1),
      backgroundFilledRisk = _ref62[0];
    return backgroundFilledRisk;
  }, ['colors.backgroundFilledRisk']),
  backgroundFilledDanger: (0, _euiThemeCommon.computed)(function (_ref63) {
    var _ref64 = _slicedToArray(_ref63, 1),
      backgroundFilledDanger = _ref64[0];
    return backgroundFilledDanger;
  }, ['colors.backgroundFilledDanger']),
  backgroundFilledText: (0, _euiThemeCommon.computed)(function (_ref65) {
    var _ref66 = _slicedToArray(_ref65, 1),
      backgroundFilledText = _ref66[0];
    return backgroundFilledText;
  }, ['colors.backgroundFilledText']),
  backgroundFilledDisabled: (0, _euiThemeCommon.computed)(function (_ref67) {
    var _ref68 = _slicedToArray(_ref67, 1),
      lightShade = _ref68[0];
    return (0, _manipulation.transparentize)(lightShade, 0.15);
  }, ['colors.lightShade']),
  backgroundFilledPrimaryHover: (0, _euiThemeCommon.computed)(function (_ref69) {
    var _ref70 = _slicedToArray(_ref69, 1),
      backgroundFilledPrimary = _ref70[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledPrimary']),
  backgroundFilledAccentHover: (0, _euiThemeCommon.computed)(function (_ref71) {
    var _ref72 = _slicedToArray(_ref71, 1),
      backgroundFilledPrimary = _ref72[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledAccent']),
  backgroundFilledAccentSecondaryHover: (0, _euiThemeCommon.computed)(function (_ref73) {
    var _ref74 = _slicedToArray(_ref73, 1),
      backgroundFilledPrimary = _ref74[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledAccentSecondary']),
  backgroundFilledNeutralHover: (0, _euiThemeCommon.computed)(function (_ref75) {
    var _ref76 = _slicedToArray(_ref75, 1),
      backgroundFilledNeutral = _ref76[0];
    return backgroundFilledNeutral;
  }, ['components.buttons.backgroundFilledNeutral']),
  backgroundFilledSuccessHover: (0, _euiThemeCommon.computed)(function (_ref77) {
    var _ref78 = _slicedToArray(_ref77, 1),
      backgroundFilledPrimary = _ref78[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledSuccess']),
  backgroundFilledWarningHover: (0, _euiThemeCommon.computed)(function (_ref79) {
    var _ref80 = _slicedToArray(_ref79, 1),
      backgroundFilledPrimary = _ref80[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledWarning']),
  backgroundFilledRiskHover: (0, _euiThemeCommon.computed)(function (_ref81) {
    var _ref82 = _slicedToArray(_ref81, 1),
      backgroundFilledRisk = _ref82[0];
    return backgroundFilledRisk;
  }, ['components.buttons.backgroundFilledRisk']),
  backgroundFilledDangerHover: (0, _euiThemeCommon.computed)(function (_ref83) {
    var _ref84 = _slicedToArray(_ref83, 1),
      backgroundFilledPrimary = _ref84[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledDanger']),
  backgroundFilledTextHover: (0, _euiThemeCommon.computed)(function (_ref85) {
    var _ref86 = _slicedToArray(_ref85, 1),
      backgroundFilledPrimary = _ref86[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledText']),
  backgroundFilledPrimaryActive: (0, _euiThemeCommon.computed)(function (_ref87) {
    var _ref88 = _slicedToArray(_ref87, 1),
      backgroundFilledPrimary = _ref88[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledPrimary']),
  backgroundFilledAccentActive: (0, _euiThemeCommon.computed)(function (_ref89) {
    var _ref90 = _slicedToArray(_ref89, 1),
      backgroundFilledPrimary = _ref90[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledAccent']),
  backgroundFilledAccentSecondaryActive: (0, _euiThemeCommon.computed)(function (_ref91) {
    var _ref92 = _slicedToArray(_ref91, 1),
      backgroundFilledPrimary = _ref92[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledAccentSecondary']),
  backgroundFilledNeutralActive: (0, _euiThemeCommon.computed)(function (_ref93) {
    var _ref94 = _slicedToArray(_ref93, 1),
      backgroundFilledNeutral = _ref94[0];
    return backgroundFilledNeutral;
  }, ['components.buttons.backgroundFilledNeutral']),
  backgroundFilledSuccessActive: (0, _euiThemeCommon.computed)(function (_ref95) {
    var _ref96 = _slicedToArray(_ref95, 1),
      backgroundFilledPrimary = _ref96[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledSuccess']),
  backgroundFilledWarningActive: (0, _euiThemeCommon.computed)(function (_ref97) {
    var _ref98 = _slicedToArray(_ref97, 1),
      backgroundFilledPrimary = _ref98[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledWarning']),
  backgroundFilledRiskActive: (0, _euiThemeCommon.computed)(function (_ref99) {
    var _ref100 = _slicedToArray(_ref99, 1),
      backgroundFilledRisk = _ref100[0];
    return backgroundFilledRisk;
  }, ['components.buttons.backgroundFilledRisk']),
  backgroundFilledDangerActive: (0, _euiThemeCommon.computed)(function (_ref101) {
    var _ref102 = _slicedToArray(_ref101, 1),
      backgroundFilledPrimary = _ref102[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledDanger']),
  backgroundFilledTextActive: (0, _euiThemeCommon.computed)(function (_ref103) {
    var _ref104 = _slicedToArray(_ref103, 1),
      backgroundFilledPrimary = _ref104[0];
    return backgroundFilledPrimary;
  }, ['components.buttons.backgroundFilledText']),
  backgroundEmptyPrimaryHover: (0, _euiThemeCommon.computed)(function (_ref105) {
    var _ref106 = _slicedToArray(_ref105, 1),
      primary = _ref106[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  backgroundEmptyAccentHover: (0, _euiThemeCommon.computed)(function (_ref107) {
    var _ref108 = _slicedToArray(_ref107, 1),
      accent = _ref108[0];
    return (0, _manipulation.transparentize)(accent, 0.1);
  }, ['colors.accent']),
  backgroundEmptyAccentSecondaryHover: (0, _euiThemeCommon.computed)(function (_ref109) {
    var _ref110 = _slicedToArray(_ref109, 1),
      success = _ref110[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundEmptyNeutralHover: (0, _manipulation.transparentize)(_colors_severity.severityColors.neutral, 0.1),
  backgroundEmptySuccessHover: (0, _euiThemeCommon.computed)(function (_ref111) {
    var _ref112 = _slicedToArray(_ref111, 1),
      success = _ref112[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundEmptyWarningHover: (0, _euiThemeCommon.computed)(function (_ref113) {
    var _ref114 = _slicedToArray(_ref113, 1),
      warning = _ref114[0];
    return (0, _manipulation.transparentize)(warning, 0.1);
  }, ['colors.warning']),
  backgroundEmptyRiskHover: (0, _manipulation.transparentize)(_colors_severity.severityColors.risk, 0.1),
  backgroundEmptyDangerHover: (0, _euiThemeCommon.computed)(function (_ref115) {
    var _ref116 = _slicedToArray(_ref115, 1),
      danger = _ref116[0];
    return (0, _manipulation.transparentize)(danger, 0.1);
  }, ['colors.danger']),
  backgroundEmptyTextHover: (0, _euiThemeCommon.computed)(function (_ref117) {
    var _ref118 = _slicedToArray(_ref117, 1),
      lightShade = _ref118[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  backgroundEmptyPrimaryActive: (0, _euiThemeCommon.computed)(function (_ref119) {
    var _ref120 = _slicedToArray(_ref119, 1),
      primary = _ref120[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  backgroundEmptyAccentActive: (0, _euiThemeCommon.computed)(function (_ref121) {
    var _ref122 = _slicedToArray(_ref121, 1),
      accent = _ref122[0];
    return (0, _manipulation.transparentize)(accent, 0.1);
  }, ['colors.accent']),
  backgroundEmptyAccentSecondaryActive: (0, _euiThemeCommon.computed)(function (_ref123) {
    var _ref124 = _slicedToArray(_ref123, 1),
      success = _ref124[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundEmptyNeutralActive: (0, _manipulation.transparentize)(_colors_severity.severityColors.neutral, 0.1),
  backgroundEmptySuccessActive: (0, _euiThemeCommon.computed)(function (_ref125) {
    var _ref126 = _slicedToArray(_ref125, 1),
      success = _ref126[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundEmptyWarningActive: (0, _euiThemeCommon.computed)(function (_ref127) {
    var _ref128 = _slicedToArray(_ref127, 1),
      warning = _ref128[0];
    return (0, _manipulation.transparentize)(warning, 0.1);
  }, ['colors.warning']),
  backgroundEmptyRiskActive: (0, _manipulation.transparentize)(_colors_severity.severityColors.risk, 0.1),
  backgroundEmptyDangerActive: (0, _euiThemeCommon.computed)(function (_ref129) {
    var _ref130 = _slicedToArray(_ref129, 1),
      danger = _ref130[0];
    return (0, _manipulation.transparentize)(danger, 0.1);
  }, ['colors.danger']),
  backgroundEmptyTextActive: (0, _euiThemeCommon.computed)(function (_ref131) {
    var _ref132 = _slicedToArray(_ref131, 1),
      lightShade = _ref132[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  textColorPrimary: (0, _euiThemeCommon.computed)(function (_ref133) {
    var _ref134 = _slicedToArray(_ref133, 1),
      primaryText = _ref134[0];
    return primaryText;
  }, ['colors.primaryText']),
  textColorAccent: (0, _euiThemeCommon.computed)(function (_ref135) {
    var _ref136 = _slicedToArray(_ref135, 1),
      accentText = _ref136[0];
    return accentText;
  }, ['colors.accentText']),
  textColorAccentSecondary: (0, _euiThemeCommon.computed)(function (_ref137) {
    var _ref138 = _slicedToArray(_ref137, 1),
      successText = _ref138[0];
    return successText;
  }, ['colors.successText']),
  textColorNeutral: (0, _euiThemeCommon.computed)(function (_ref139) {
    var _ref140 = _slicedToArray(_ref139, 1),
      textNeutral = _ref140[0];
    return textNeutral;
  }, ['colors.textNeutral']),
  textColorSuccess: (0, _euiThemeCommon.computed)(function (_ref141) {
    var _ref142 = _slicedToArray(_ref141, 1),
      successText = _ref142[0];
    return successText;
  }, ['colors.successText']),
  textColorWarning: (0, _euiThemeCommon.computed)(function (_ref143) {
    var _ref144 = _slicedToArray(_ref143, 1),
      warningText = _ref144[0];
    return warningText;
  }, ['colors.warningText']),
  textColorRisk: (0, _euiThemeCommon.computed)(function (_ref145) {
    var _ref146 = _slicedToArray(_ref145, 1),
      textRisk = _ref146[0];
    return textRisk;
  }, ['colors.textRisk']),
  textColorDanger: (0, _euiThemeCommon.computed)(function (_ref147) {
    var _ref148 = _slicedToArray(_ref147, 1),
      dangerText = _ref148[0];
    return dangerText;
  }, ['colors.dangerText']),
  textColorText: (0, _euiThemeCommon.computed)(function (_ref149) {
    var _ref150 = _slicedToArray(_ref149, 1),
      text = _ref150[0];
    return text;
  }, ['colors.text']),
  textColorDisabled: (0, _euiThemeCommon.computed)(function (_ref151) {
    var _ref152 = _slicedToArray(_ref151, 1),
      disabledText = _ref152[0];
    return disabledText;
  }, ['colors.disabledText']),
  textColorFilledPrimary: (0, _euiThemeCommon.computed)(function (_ref153) {
    var _ref154 = _slicedToArray(_ref153, 3),
      primary = _ref154[0],
      ghost = _ref154[1],
      ink = _ref154[2];
    return isDark(primary) ? ghost : ink;
  }, ['colors.primary', 'colors.ghost', 'colors.ink']),
  textColorFilledAccent: (0, _euiThemeCommon.computed)(function (_ref155) {
    var _ref156 = _slicedToArray(_ref155, 3),
      accent = _ref156[0],
      ghost = _ref156[1],
      ink = _ref156[2];
    return isDark(accent) ? ghost : ink;
  }, ['colors.accent', 'colors.ghost', 'colors.ink']),
  textColorFilledAccentSecondary: (0, _euiThemeCommon.computed)(function (_ref157) {
    var _ref158 = _slicedToArray(_ref157, 3),
      success = _ref158[0],
      ghost = _ref158[1],
      ink = _ref158[2];
    var background = (0, _manipulation.tint)(success, 0.3);
    return isDark(background) ? ghost : ink;
  }, ['colors.success', 'colors.ghost', 'colors.ink']),
  textColorFilledNeutral: (0, _euiThemeCommon.computed)(function (_ref159) {
    var _ref160 = _slicedToArray(_ref159, 2),
      ghost = _ref160[0],
      ink = _ref160[1];
    var background = (0, _manipulation.tint)(_colors_severity.severityColors.neutral, 0.3);
    return isDark(background) ? ghost : ink;
  }, ['colors.ghost', 'colors.ink']),
  textColorFilledSuccess: (0, _euiThemeCommon.computed)(function (_ref161) {
    var _ref162 = _slicedToArray(_ref161, 3),
      success = _ref162[0],
      ghost = _ref162[1],
      ink = _ref162[2];
    var background = (0, _manipulation.tint)(success, 0.3);
    return isDark(background) ? ghost : ink;
  }, ['colors.success', 'colors.ghost', 'colors.ink']),
  textColorFilledWarning: (0, _euiThemeCommon.computed)(function (_ref163) {
    var _ref164 = _slicedToArray(_ref163, 3),
      warning = _ref164[0],
      ghost = _ref164[1],
      ink = _ref164[2];
    return isDark(warning) ? ghost : ink;
  }, ['colors.warning', 'colors.ghost', 'colors.ink']),
  textColorFilledRisk: (0, _euiThemeCommon.computed)(function (_ref165) {
    var _ref166 = _slicedToArray(_ref165, 2),
      ghost = _ref166[0],
      ink = _ref166[1];
    var background = (0, _manipulation.tint)(_colors_severity.severityColors.risk, 0.3);
    return isDark(background) ? ghost : ink;
  }, ['colors.ghost', 'colors.ink']),
  textColorFilledDanger: (0, _euiThemeCommon.computed)(function (_ref167) {
    var _ref168 = _slicedToArray(_ref167, 3),
      danger = _ref168[0],
      ghost = _ref168[1],
      ink = _ref168[2];
    return isDark(danger) ? ghost : ink;
  }, ['colors.danger', 'colors.ghost', 'colors.ink']),
  textColorFilledText: (0, _euiThemeCommon.computed)(function (_ref169) {
    var _ref170 = _slicedToArray(_ref169, 3),
      darkShade = _ref170[0],
      ghost = _ref170[1],
      ink = _ref170[2];
    return isDark(darkShade) ? ghost : ink;
  }, ['colors.darkShade', 'colors.ghost', 'colors.ink']),
  textColorFilledDisabled: (0, _euiThemeCommon.computed)(function (_ref171) {
    var _ref172 = _slicedToArray(_ref171, 1),
      disabledText = _ref172[0];
    return disabledText;
  }, ['colors.disabledText'])
};
var _dark_buttons = _objectSpread(_objectSpread({}, _buttons), {}, {
  backgroundFilledDisabled: (0, _euiThemeCommon.computed)(function (_ref173) {
    var _ref174 = _slicedToArray(_ref173, 1),
      lightShade = _ref174[0];
    return (0, _manipulation.transparentize)(lightShade, 0.15);
  }, ['colors.lightShade']),
  backgroundEmptyTextHover: (0, _euiThemeCommon.computed)(function (_ref175) {
    var _ref176 = _slicedToArray(_ref175, 1),
      lightShade = _ref176[0];
    return (0, _manipulation.transparentize)(lightShade, 0.4);
  }, ['colors.lightShade']),
  textColorFilledAccent: (0, _euiThemeCommon.computed)(function (_ref177) {
    var _ref178 = _slicedToArray(_ref177, 3),
      accent = _ref178[0],
      ghost = _ref178[1],
      ink = _ref178[2];
    return isDark(accent) ? ghost : ink;
  }, ['colors.accent', 'colors.ghost', 'colors.ink']),
  textColorFilledSuccess: (0, _euiThemeCommon.computed)(function (_ref179) {
    var _ref180 = _slicedToArray(_ref179, 3),
      success = _ref180[0],
      ghost = _ref180[1],
      ink = _ref180[2];
    return isDark(success) ? ghost : ink;
  }, ['colors.success', 'colors.ghost', 'colors.ink']),
  textColorFilledText: (0, _euiThemeCommon.computed)(function (_ref181) {
    var _ref182 = _slicedToArray(_ref181, 3),
      text = _ref182[0],
      ghost = _ref182[1],
      ink = _ref182[2];
    return isDark(text) ? ghost : ink;
  }, ['colors.text', 'colors.ghost', 'colors.ink'])
});
var buttons = exports.buttons = {
  LIGHT: _buttons,
  DARK: _dark_buttons
};