"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTreeViewItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _icon = require("../icon");
var _tree_view_item = require("./tree_view_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "label", "className", "children", "display", "icon", "hasArrow", "isActive", "isExpanded", "buttonRef", "wrapperProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiTreeViewItem = exports.EuiTreeViewItem = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var id = _ref.id,
    label = _ref.label,
    className = _ref.className,
    children = _ref.children,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'default' : _ref$display,
    icon = _ref.icon,
    hasArrow = _ref.hasArrow,
    isActive = _ref.isActive,
    isExpanded = _ref.isExpanded,
    buttonRef = _ref.buttonRef,
    wrapperProps = _ref.wrapperProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_tree_view_item.euiTreeViewItemStyles);
  var wrapperClasses = (0, _classnames.default)('euiTreeView__node', {
    'euiTreeView__node--expanded': isExpanded
  }, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.className);
  var wrapperStyles = [styles.li.euiTreeView__node, styles.li[display], isExpanded && styles.li.expanded];
  var buttonClasses = (0, _classnames.default)('euiTreeView__nodeInner', className, {
    'euiTreeView__node--active': isActive
  });
  var buttonStyles = [styles.button.euiTreeView__nodeInner, styles.button[display]];
  var iconStyles = [styles.icon.euiTreeView__iconWrapper, styles.icon[display]];
  return (0, _react2.jsx)("li", _extends({}, wrapperProps, {
    css: wrapperStyles,
    className: wrapperClasses
  }), (0, _react2.jsx)("button", _extends({
    id: id,
    css: buttonStyles,
    className: buttonClasses,
    "aria-expanded": isExpanded,
    ref: buttonRef
  }, rest), hasArrow && (!!children ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiTreeView__expansionArrow",
    size: display === 'compressed' ? 's' : 'm',
    type: isExpanded ? 'arrowDown' : 'arrowRight'
  }) : (0, _react2.jsx)("span", {
    css: iconStyles,
    className: "euiTreeView__arrowPlaceholder"
  })), icon && (0, _react2.jsx)("span", {
    css: iconStyles,
    className: "euiTreeView__iconWrapper"
  }, icon), (0, _react2.jsx)("span", {
    className: "euiTreeView__nodeLabel eui-textTruncate"
  }, label)), children);
});
EuiTreeViewItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Required for `aria-controls` accessibility
       */
  id: _propTypes.default.string.isRequired,
  /**
       * The main button content
       */
  label: _propTypes.default.node.isRequired,
  /**
       * Used to render nested `EuiTreeView`s
       */
  children: _propTypes.default.node,
  /**
       * Optional icon to render. Pass, e.g., `<EuiIcon />` or `<EuiToken />`
       */
  icon: _propTypes.default.node,
  /**
       * Renders an arrow if `children` exists. Otherwise renders a blank icon
       */
  hasArrow: _propTypes.default.bool,
  /**
       * Adds a targetable modifier class
       */
  isActive: _propTypes.default.bool,
  /**
       * Sets the `aria-expanded` attribute
       */
  isExpanded: _propTypes.default.bool,
  /**
       * Determines default or compressed display
       */
  display: _propTypes.default.oneOf(["default", "compressed"]),
  buttonRef: _propTypes.default.any,
  /**
       * Optional extra props to pass to the wrapping `<li>`
       */
  wrapperProps: _propTypes.default.any
};
EuiTreeViewItem.displayName = 'EuiTreeViewItem';