"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUTTER_SIZES = exports.EuiTimeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _timeline_item = require("./timeline_item");
var _timeline = require("./timeline.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "items", "children", "gutterSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var GUTTER_SIZES = exports.GUTTER_SIZES = ['m', 'l', 'xl'];
var EuiTimeline = exports.EuiTimeline = function EuiTimeline(_ref) {
  var className = _ref.className,
    _ref$items = _ref.items,
    items = _ref$items === void 0 ? [] : _ref$items,
    children = _ref.children,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'xl' : _ref$gutterSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiTimeline', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _timeline.euiTimelineStyles)(euiTheme);
  var cssStyles = [styles.euiTimeline, styles[gutterSize]];
  return (
    // eslint-disable-next-line jsx-a11y/no-redundant-roles
    (0, _react2.jsx)("ol", _extends({
      className: classes,
      css: cssStyles,
      role: "list"
    }, rest), items.map(function (item, index) {
      return (0, _react2.jsx)(_timeline_item.EuiTimelineItem, _extends({
        key: index
      }, item));
    }), children)
  );
};
EuiTimeline.propTypes = {
  /**
     * List of timeline items to render. See {@link EuiTimelineItem}
     */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Vertical alignment of the event with the icon
       */
    verticalAlign: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired),
  /**
     * Sets the size of the vertical space between each timeline item
     */
  gutterSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};