"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT_SIZES = exports.EuiText = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _text_color = require("./text_color");
var _text_align = require("./text_align");
var _text = require("./text.styles");
var _react2 = require("@emotion/react");
var _excluded = ["component", "size", "color", "grow", "textAlign", "children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var TEXT_SIZES = exports.TEXT_SIZES = ['xs', 's', 'm', 'relative'];
var EuiText = exports.EuiText = function EuiText(_ref) {
  var _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    color = _ref.color,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    textAlign = _ref.textAlign,
    children = _ref.children,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_text.euiTextStyles);
  var cssStyles = [styles.euiText, !grow ? styles.constrainedWidth : undefined, styles[size]];
  var classes = (0, _classnames.default)('euiText', className);
  var Component = component;
  var text = (0, _react2.jsx)(Component, _extends({
    css: cssStyles,
    className: classes
  }, rest), children);
  if (color) {
    text = (0, _react2.jsx)(_text_color.EuiTextColor, {
      component: component,
      color: color,
      className: classes,
      cloneElement: true
    }, text);
  }
  if (textAlign) {
    text = (0, _react2.jsx)(_text_align.EuiTextAlign, {
      component: component,
      textAlign: textAlign,
      className: classes,
      cloneElement: true
    }, text);
  }
  return text;
};
EuiText.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * The HTML element/tag to render.
       * Use with care when nesting multiple components to ensure valid XHTML:
       * - `<div>` and other block tags are not valid to use inside `<p>`. If using the `<p>` tag, we recommend passing strings/text only.
       * - `<span>` is valid to be nested in any tag, and can have any tag nested within it.
       */
  component: _propTypes.default.oneOf(["div", "span", "p"]),
  /**
     * Any of our named colors or a `hex`, `rgb` or `rgba` value.
     * @default inherit
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  /**
     * Applies horizontal text alignment
     * @default left
     */
  textAlign: _propTypes.default.any,
  /**
       * Determines the text size. Choose `relative` to control the `font-size` based on the value of a parent container.
       */
  size: _propTypes.default.any,
  grow: _propTypes.default.bool
};