"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSideNavHeading = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _title = require("../title");
var _accessibility = require("../accessibility");
var _excluded = ["children", "id", "className", "element", "screenReaderOnly", "size", "textTransform"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiSideNavHeading = exports.EuiSideNavHeading = function EuiSideNavHeading(_ref) {
  var children = _ref.children,
    id = _ref.id,
    className = _ref.className,
    _ref$element = _ref.element,
    HeadingElement = _ref$element === void 0 ? 'h2' : _ref$element,
    _ref$screenReaderOnly = _ref.screenReaderOnly,
    screenReaderOnly = _ref$screenReaderOnly === void 0 ? false : _ref$screenReaderOnly,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'xs' : _ref$size,
    textTransform = _ref.textTransform,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSideNav__heading', className);
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  return screenReaderOnly ? (0, _react.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react.jsx)(HeadingElement, _extends({
    id: id,
    className: classes
  }, rest), children)) : (0, _react.jsx)(_title.EuiTitle, {
    size: size,
    textTransform: textTransform
  }, (0, _react.jsx)(HeadingElement, _extends({
    id: id,
    className: classes,
    css: /*#__PURE__*/(0, _react.css)({
      marginBlockEnd: euiTheme.size.l
    }, ";label:EuiSideNavHeading;")
  }, rest), children));
};
EuiSideNavHeading.propTypes = {
  children: _propTypes.default.node.isRequired,
  /**
     * The actual HTML heading element to wrap the `heading`.
     * Default is `h2`
     */
  element: _propTypes.default.oneOf(["h1", "h2", "h3", "h4", "h5", "h6", "span"]),
  /**
     * For best accessibility, `<nav>` elements should have a nested heading. But you can hide this element if it's redundent from something else (except on mobile).
     */
  screenReaderOnly: _propTypes.default.bool
};