"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _euiThemeBorealis = require("@elastic/eui-theme-borealis");
var _services = require("../../services");
var _warning = require("../../services/theme/warning");
var _css = require("../../services/emotion/css");
var _global_styles = require("../../global_styling/reset/global_styles");
var _utility = require("../../global_styling/utility/utility");
var _cache = require("./cache");
var _system_defaults = require("./system_defaults");
var _nested = require("./nested");
var _component_defaults = require("./component_defaults");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var isEmotionCacheObject = function isEmotionCacheObject(obj) {
  return obj.hasOwnProperty('key');
};
var EuiProvider = exports.EuiProvider = function EuiProvider(_ref) {
  var _defaultCache;
  var _ref$cache = _ref.cache,
    cache = _ref$cache === void 0 ? _css.cache : _ref$cache,
    _ref$theme = _ref.theme,
    theme = _ref$theme === void 0 ? _euiThemeBorealis.EuiThemeBorealis : _ref$theme,
    _ref$globalStyles = _ref.globalStyles,
    Globals = _ref$globalStyles === void 0 ? _global_styles.EuiGlobalStyles : _ref$globalStyles,
    _ref$utilityClasses = _ref.utilityClasses,
    Utilities = _ref$utilityClasses === void 0 ? _utility.EuiUtilityClasses : _ref$utilityClasses,
    colorMode = _ref.colorMode,
    highContrastMode = _ref.highContrastMode,
    modify = _ref.modify,
    componentDefaults = _ref.componentDefaults,
    children = _ref.children;
  var isNested = (0, _nested.useIsNestedEuiProvider)();
  if (isNested) {
    var providerMessage = "`EuiProvider` should not be nested or used more than once, other than at the top level of your app.\n    Use `EuiThemeProvider` instead for nested component-level theming: https://ela.st/euiprovider.";
    (0, _warning.emitEuiProviderWarning)(providerMessage);
    return children;
  }
  var defaultCache;
  var globalCache;
  var utilityCache;
  if (cache) {
    if (isEmotionCacheObject(cache)) {
      cache.compat = true;
      defaultCache = cache;
    } else {
      if (cache.default) {
        cache.default.compat = true;
      }
      defaultCache = cache.default;
      if (cache.global) {
        cache.global.compat = true;
      }
      globalCache = cache.global;
      if (cache.utility) {
        cache.utility.compat = true;
      }
      utilityCache = cache.utility;
    }
  }
  return (0, _react2.jsx)(_nested.EuiProviderNestedCheck, null, (0, _react2.jsx)(_cache.EuiCacheProvider, {
    cache: (_defaultCache = defaultCache) !== null && _defaultCache !== void 0 ? _defaultCache : _css.cache
  }, (0, _react2.jsx)(_system_defaults.EuiSystemDefaultsProvider, null, (0, _react2.jsx)(_services.EuiThemeProvider, {
    theme: theme !== null && theme !== void 0 ? theme : undefined,
    colorMode: colorMode,
    highContrastMode: highContrastMode,
    modify: modify
  }, theme && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_cache.EuiCacheProvider, {
    cache: globalCache,
    children: Globals && (0, _react2.jsx)(Globals, null)
  }), (0, _react2.jsx)(_cache.EuiCacheProvider, {
    cache: utilityCache,
    children: Utilities && (0, _react2.jsx)(Utilities, null)
  })), (0, _react2.jsx)(_component_defaults.EuiComponentDefaultsProvider, {
    componentDefaults: componentDefaults
  }, children)))));
};