"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeLabelStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _range = require("./range.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiRangeLabelStyles = exports.euiRangeLabelStyles = function euiRangeLabelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiRangeLabel: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";;label:euiRangeLabel;"),
    min: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-right', euiTheme.size.s), ";;label:min;"),
    max: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-left', euiTheme.size.s), ";;label:max;"),
    isDisabled: /*#__PURE__*/(0, _react.css)("opacity:", range.disabledOpacity, ";;label:isDisabled;")
  };
};