"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeHighlightStyles = exports.euiRangeHighlightProgressStyles = exports.euiRangeHighlightLevelsWrapperStyles = exports.euiRangeHighlightLevelsStyles = void 0;
var _react = require("@emotion/react");
var _high_contrast = require("../../../global_styling/functions/high_contrast");
var _range = require("./range.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiRangeHighlightStyles = exports.euiRangeHighlightStyles = function euiRangeHighlightStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiRangeHighlight: /*#__PURE__*/(0, _react.css)("position:absolute;block-size:", range.highlightHeight, ";inset-inline-start:0;inline-size:100%;overflow:hidden;z-index:", range.highlightZIndex, ";pointer-events:none;inset-block-start:", range.trackTopPositionWithoutTicks, ";;label:euiRangeHighlight;"),
    hasTicks: /*#__PURE__*/(0, _react.css)("inset-block-start:", range.trackTopPositionWithTicks, ";;label:hasTicks;")
  };
};
var euiRangeHighlightProgressStyles = exports.euiRangeHighlightProgressStyles = function euiRangeHighlightProgressStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiRangeHighlight__progress: /*#__PURE__*/(0, _react.css)("block-size:", range.highlightHeight, ";border-radius:", range.trackBorderRadius, ";background-color:", range.highlightColor, ";", (0, _high_contrast.preventForcedColors)(euiThemeContext), ".euiRangeSlider:focus-visible~.euiRangeHighlight &,.euiRangeThumb:focus-visible~.euiRangeHighlight &,.euiRangeDraggable:focus~.euiRangeHighlight &{background-color:", range.focusColor, ";};label:euiRangeHighlight__progress;")
  };
};
var euiRangeHighlightLevelsWrapperStyles = exports.euiRangeHighlightLevelsWrapperStyles = function euiRangeHighlightLevelsWrapperStyles(euiThemeContext) {
  var euiRangeVars = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiRangeHighlight__levelsWrapper: /*#__PURE__*/(0, _react.css)("block-size:", euiRangeVars.trackHeight, ";position:relative;overflow:hidden;;label:euiRangeHighlight__levelsWrapper;")
  };
};
var euiRangeHighlightLevelsStyles = exports.euiRangeHighlightLevelsStyles = function euiRangeHighlightLevelsStyles(euiThemeContext) {
  var euiRangeVars = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiRangeHighlight__levels: /*#__PURE__*/(0, _react.css)("background:transparent;block-size:", euiRangeVars.trackHeight, ";inset-block-start:0;;label:euiRangeHighlight__levels;")
  };
};