"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormLabel = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _form_label = require("./form_label.styles");
var _react2 = require("@emotion/react");
var _excluded = ["type", "isFocused", "isInvalid", "isDisabled", "children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFormLabel = exports.EuiFormLabel = function EuiFormLabel(_ref) {
  var _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'label' : _ref$type,
    isFocused = _ref.isFocused,
    isInvalid = _ref.isInvalid,
    isDisabled = _ref.isDisabled,
    children = _ref.children,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_form_label.euiFormLabelStyles);
  var cssStyles = [styles.euiFormLabel, !isDisabled && styles.notDisabled, isInvalid && styles.invalid, isFocused && styles.focused];
  var classes = (0, _classnames.default)('euiFormLabel', className, {
    'euiFormLabel-isFocused': isFocused,
    'euiFormLabel-isInvalid': isInvalid,
    'euiFormLabel-isDisabled': isDisabled
  });
  if (type === 'legend') {
    return (0, _react2.jsx)("legend", _extends({
      css: cssStyles,
      className: classes
    }, rest), children);
  } else {
    return (0, _react2.jsx)("label", _extends({
      css: cssStyles,
      className: classes
    }, rest), children);
  }
};
EuiFormLabel.propTypes = {
  /**
     * Default type is a `label` but can be changed to a `legend`
     * if using inside a `fieldset`.
     */
  /**
     * Default type is a `label` but can be changed to a `legend`
     * if using inside a `fieldset`.
     */
  type: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["label"]), _propTypes.default.oneOf(["label", "legend"])]), _propTypes.default.oneOfType([_propTypes.default.oneOf(["legend"]).isRequired, _propTypes.default.oneOf(["label", "legend"])])]),
  isFocused: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,
  /**
     * Changes `cursor` to `default`.
     */
  /**
     * Changes `cursor` to `default`.
     */
  isDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};