"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormLegendStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form_label = require("../form_label/form_label.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFormLegendStyles = exports.euiFormLegendStyles = function euiFormLegendStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFormLegend: /*#__PURE__*/(0, _react.css)((0, _form_label.euiFormLabel)(euiThemeContext), ";;label:euiFormLegend;"),
    // Skip css`` to avoid generating an extra Emotion className
    uncompressed: (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s),
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.xs), ";label:compressed;")
  };
};