"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRightSideIcon = exports.getIconAffordanceStyles = void 0;
var _form_control_layout_icons = require("./form_control_layout_icons");
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var isRightSideIcon = exports.isRightSideIcon = function isRightSideIcon(icon) {
  return !!icon && (0, _form_control_layout_icons.isIconShape)(icon) && icon.side === 'right';
};
var getIconAffordanceStyles = exports.getIconAffordanceStyles = function getIconAffordanceStyles(_ref) {
  var icon = _ref.icon,
    clear = _ref.clear,
    isLoading = _ref.isLoading,
    isInvalid = _ref.isInvalid,
    isDropdown = _ref.isDropdown;
  var cssVariables = {
    '--euiFormControlLeftIconsCount': 0,
    '--euiFormControlRightIconsCount': 0
  };
  if (icon) {
    if (isRightSideIcon(icon)) {
      cssVariables['--euiFormControlRightIconsCount']++;
    } else {
      cssVariables['--euiFormControlLeftIconsCount']++;
    }
  }
  if (clear) cssVariables['--euiFormControlRightIconsCount']++;
  if (isLoading) cssVariables['--euiFormControlRightIconsCount']++;
  if (isInvalid) cssVariables['--euiFormControlRightIconsCount']++;
  if (isDropdown) cssVariables['--euiFormControlRightIconsCount']++;
  var filtered = Object.entries(cssVariables).filter(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      count = _ref3[1];
    return count > 0;
  });
  return filtered.length ? Object.fromEntries(filtered) : undefined;
};