"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiReactDatePickerStyles = exports.euiDatePickerVariables = void 0;
var _css = require("@emotion/css");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _mixins = require("../../global_styling/mixins");
var _form = require("../form/form.styles");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // Needs to use vanilla `css` to pass a className directly to react-datepicker
var euiDatePickerVariables = exports.euiDatePickerVariables = function euiDatePickerVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var unsetHighContrastBorder = function unsetHighContrastBorder(styles) {
    return _objectSpread(_objectSpread({}, styles), {}, {
      border: undefined
    });
  };
  return {
    gapSize: euiTheme.size.xs,
    get paddingSize() {
      return (0, _global_styling.mathWithUnits)(this.gapSize, function (x) {
        return x * 2;
      });
    },
    headerButtonSize: euiTheme.size.xl,
    get headerOffset() {
      return (0, _global_styling.mathWithUnits)([this.headerButtonSize, this.gapSize], function (x, y) {
        return x + y;
      });
    },
    colors: {
      day: {
        inMonth: euiTheme.colors.textHeading,
        outsideMonth: euiTheme.colors.textSubdued,
        header: euiTheme.colors.textSubdued,
        today: euiTheme.colors.primary
      },
      hover: unsetHighContrastBorder((0, _mixins.euiButtonColor)(euiThemeContext, 'primary')),
      disabled: unsetHighContrastBorder((0, _mixins.euiButtonColor)(euiThemeContext, 'disabled')),
      get inRange() {
        return this.hover;
      },
      inRangeAndDisabled: {
        backgroundColor: (0, _mixins.euiButtonEmptyColor)(euiThemeContext, 'primary').backgroundColor
      },
      selected: highContrastMode !== 'forced' ? (0, _mixins.euiButtonFillColor)(euiThemeContext, 'primary') : {
        color: euiTheme.colors.emptyShade,
        backgroundColor: euiTheme.colors.fullShade,
        forcedColorAdjust: 'none'
      },
      selectedAndDisabled: highContrastMode !== 'forced' ? (0, _mixins.euiButtonColor)(euiThemeContext, 'danger') : {
        color: euiTheme.colors.textDanger,
        backgroundColor: euiTheme.colors.emptyShade,
        border: "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.textDanger, ";")
      },
      highlighted: (0, _mixins.euiButtonColor)(euiThemeContext, 'success')
    },
    animationSpeed: euiTheme.animation.fast
  };
};
var euiReactDatePickerStyles = exports.euiReactDatePickerStyles = function euiReactDatePickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var datePickerVars = euiDatePickerVariables(euiThemeContext);
  var gapSize = datePickerVars.gapSize,
    paddingSize = datePickerVars.paddingSize,
    headerOffset = datePickerVars.headerOffset;
  return {
    euiReactDatePicker: /*#__PURE__*/(0, _css.css)("display:flex;justify-content:center;padding:", paddingSize, ";font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";color:", euiTheme.colors.textParagraph, ";border-radius:", euiTheme.border.radius.medium, ";&.react-datepicker--non-interactive{pointer-events:none;}.react-datepicker__focusTrap{display:flex;justify-content:center;gap:", paddingSize, ";}", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 's'), "{&,.react-datepicker__focusTrap{flex-direction:column;}}.react-datepicker__header__dropdown{position:absolute;", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('horizontal', headerOffset), " padding:", paddingSize, ";display:flex;justify-content:center;gap:", gapSize, ";}.react-datepicker__navigation{z-index:1;position:absolute;", (0, _global_styling.logicalCSS)('top', paddingSize), "&:hover,&:focus{transform:none;}}.react-datepicker__navigation--previous{", (0, _global_styling.logicalCSS)('left', paddingSize), ";}.react-datepicker__navigation--next{", (0, _global_styling.logicalCSS)('right', paddingSize), ";}.react-datepicker__month-container{flex-grow:1;", (0, _global_styling.logicalCSS)('margin-top', headerOffset), ";}.react-datepicker__time-container{flex-grow:1;", (0, _global_styling.logicalCSS)('margin-top',
    // The time select gets a little extra offset
    (0, _global_styling.mathWithUnits)([headerOffset, gapSize], function (x, y) {
      return x + y;
    })), " ", (0, _global_styling.logicalCSS)('margin-left', paddingSize), (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 's'), "{", (0, _global_styling.logicalCSS)('margin-top', gapSize), " ", (0, _global_styling.logicalCSS)('margin-left', 0), ";}}", _monthYearDropdowns(euiThemeContext, datePickerVars), " ", _dayCalendarStyles(euiThemeContext, datePickerVars), " ", _timeSelectStyles(euiThemeContext, datePickerVars), ";;label:euiReactDatePicker;")
  };
};
var _monthYearDropdowns = function _monthYearDropdowns(euiThemeContext, _ref) {
  var colors = _ref.colors;
  var euiTheme = euiThemeContext.euiTheme;
  var formStyles = (0, _form.euiFormControlStyles)(euiThemeContext);
  return /*#__PURE__*/(0, _css.css)(".react-datepicker__year-read-view,.react-datepicker__month-read-view,.react-datepicker__month-year-read-view{display:flex;justify-content:space-between;align-items:center;", formStyles.compressed, " ", (0, _form.euiFormControlText)(euiThemeContext), " font-weight:", euiTheme.font.weight.medium, ";", (0, _form.euiFormControlDefaultShadow)(euiThemeContext), " &:hover{cursor:pointer;text-decoration:underline;}}.react-datepicker__year-dropdown-container{position:relative;flex-grow:1;}.react-datepicker__month-dropdown-container{position:relative;flex-grow:2;}.react-datepicker__year-dropdown,.react-datepicker__month-dropdown{z-index:1;position:absolute;", (0, _global_styling.euiYScroll)(euiThemeContext, {
    height: 'auto'
  }), " ", (0, _global_styling.logicalCSS)('max-height', '250px'), " ", (0, _global_styling.logicalCSS)('width', '100%'), " padding:", euiTheme.size.xs, ";background-color:", euiTheme.colors.emptyShade, ";border-radius:", euiTheme.border.radius.medium, ";", (0, _euiThemeCommon.euiShadowSmall)(euiThemeContext, {
    borderAllInHighContrastMode: true
  }), ";}.react-datepicker__year-dropdown{", (0, _global_styling.logicalCSS)('min-width', '100px'), ";}.react-datepicker__month-dropdown{", (0, _global_styling.logicalCSS)('min-width', '140px'), ";}.react-datepicker__year-option,.react-datepicker__month-option,.react-datepicker__month-year-option{display:flex;align-items:center;", (0, _global_styling.logicalCSS)('height', euiTheme.size.l), " ", (0, _global_styling.logicalCSS)('margin-vertical', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), " font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";border-radius:", euiTheme.border.radius.small, ";cursor:pointer;&:hover{text-decoration:underline;}&--preselected{", colors.hover, ";}&--selected_year,&--selected_month{", colors.selected, ";}&--selected{display:none;}}");
};
var _dayCalendarStyles = function _dayCalendarStyles(euiThemeContext, _ref2) {
  var gapSize = _ref2.gapSize,
    colors = _ref2.colors,
    animationSpeed = _ref2.animationSpeed;
  var euiTheme = euiThemeContext.euiTheme;
  var daySize = euiTheme.size.xl;
  var dayMargin = (0, _global_styling.mathWithUnits)(gapSize, function (x) {
    return x / 2;
  });
  var rangeMarginOffset = (0, _global_styling.mathWithUnits)(dayMargin, function (x) {
    return x * 1.5;
  });
  return /*#__PURE__*/(0, _css.css)(".react-datepicker__day-names,.react-datepicker__week{display:flex;justify-content:space-between;flex-grow:1;color:", colors.day.header, ";}.react-datepicker__day-name,.react-datepicker__day{display:inline-flex;justify-content:center;align-items:center;", (0, _global_styling.logicalSizeCSS)(daySize), " margin:", dayMargin, ";font-weight:", euiTheme.font.weight.medium, ";}.react-datepicker__day{color:", colors.day.inMonth, ";border-radius:", euiTheme.border.radius.small, ";", _global_styling.euiCanAnimate, "{transition:transform ", animationSpeed, " ease-in-out,background-color ", animationSpeed, " ease-in;}&:hover{", colors.hover, " text-decoration:underline;cursor:pointer;", _global_styling.euiCanAnimate, "{transform:scale(1.1);}}&--today{color:", colors.day.today, ";font-weight:", euiTheme.font.weight.bold, ";}&--outside-month{color:", colors.day.outsideMonth, ";}&--highlighted,&--highlighted:hover{", colors.highlighted, ";}&--in-range,&--in-range:hover{", colors.inRange, ";}", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    // Ranges use 2 side box-shadows that are the same as the button
    // background to fill the gap between margins
    none: "\n          &--in-range:not(&--selected):not(:hover):not(&--disabled) {\n            box-shadow: -".concat(rangeMarginOffset, " 0 ").concat(colors.inRange.backgroundColor, ",\n              ").concat(rangeMarginOffset, " 0 ").concat(colors.inRange.backgroundColor, ";\n            border-radius: 0;\n\n            &:first-child {\n              box-shadow: ").concat(rangeMarginOffset, " 0 ").concat(colors.inRange.backgroundColor, ";\n            }\n\n            &:last-child {\n              box-shadow: -").concat(rangeMarginOffset, " 0 ").concat(colors.inRange.backgroundColor, ";\n            }\n          }\n          /* Animate smoothly on hover */\n          &--in-range:not(&--selected) {\n            ").concat(_global_styling.euiCanAnimate, " {\n              transition: transform ").concat(animationSpeed, " ease-in-out,\n                box-shadow ").concat(animationSpeed, " ease-in-out,\n                border-radius ").concat(animationSpeed, " ease-in-out,\n                background-color ").concat(animationSpeed, " ease-in;\n            }\n          }\n        "),
    // In Windows high contrast mode, use borders and pseudo elements instead of background colors
    forced: "\n          &--in-range:not(&--selected) {\n            position: relative;\n            transform: none;\n\n            &::before {\n              content: '';\n              position: absolute;\n              inset-inline: -".concat(dayMargin, ";\n              inset-block: ").concat(dayMargin, ";\n              border-block: ").concat(euiTheme.border.thin, ";\n              pointer-events: none;\n            }\n          }\n          &--range-start:not(&--selected)::before {\n            border-inline-start: ").concat(euiTheme.border.thin, ";\n          }\n          &--range-end:not(&--selected)::before {\n            border-inline-end: ").concat(euiTheme.border.thin, ";\n          }\n        ")
  }), " &--selected,&--selected:hover,&--in-selecting-range,&--in-selecting-range:hover{", colors.selected, ";}&--disabled,&--disabled:hover{", colors.disabled, " ", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    forced: 'opacity: 0.5;'
  }), " cursor:not-allowed;text-decoration:none;transform:none;}&--disabled.react-datepicker__day--in-range:not(&--selected){&,&:hover{", colors.inRangeAndDisabled, ";}}&--in-selecting-range:not(&--in-range),&--disabled.react-datepicker__day--selected,&--disabled.react-datepicker__day--selected:hover{", colors.selectedAndDisabled, " ", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    forced: 'opacity: 1;'
  }), ";}}");
};
var _timeSelectStyles = function _timeSelectStyles(euiThemeContext, _ref3) {
  var gapSize = _ref3.gapSize,
    colors = _ref3.colors,
    animationSpeed = _ref3.animationSpeed;
  var euiTheme = euiThemeContext.euiTheme;
  return /*#__PURE__*/(0, _css.css)(".react-datepicker__time-container{display:flex;", (0, _global_styling.logicalCSS)('width', 'auto'), " background-color:", euiTheme.colors.body, ";border-radius:", euiTheme.border.radius.medium, ";&--focus{.react-datepicker__time-list-item--preselected{text-decoration:underline;}}}.react-datepicker__time,.react-datepicker__time-box{display:flex;flex-direction:column;flex-grow:1;}.react-datepicker__time-list{", (0, _global_styling.euiYScroll)(euiThemeContext, {
    height: '100px'
  }), " display:flex;flex-direction:column;flex-grow:1;align-items:center;gap:", gapSize, ";", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.m), " &:focus-visible{outline-style:auto;}}.react-datepicker__time-list-item{display:flex;justify-content:align-center;align-items:center;", (0, _global_styling.logicalCSS)('min-height', euiTheme.size.l), " ", (0, _global_styling.logicalCSS)('margin-horizontal', 'auto'), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), " font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";font-weight:", euiTheme.font.weight.medium, ";white-space:nowrap;border-radius:", euiTheme.border.radius.small, ";&:not(:disabled):hover{text-decoration:underline;cursor:pointer;}&--disabled{cursor:not-allowed;color:", colors.disabled.color, ";}&--injected{", colors.highlighted, ";}&--selected{", colors.selected, ";}&--preselected{", colors.hover, " ", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    // Use negative margins to offset the added border width
    forced: "\n            border: ".concat(euiTheme.border.thin, ";\n            margin-inline: -").concat(euiTheme.border.width.thin, ";\n          ")
  }), ";}", _global_styling.euiCanAnimate, "{transition:background-color ", animationSpeed, " ease-in;}}&.react-datepicker--time-only{padding:0;.react-datepicker__time-container{background-color:transparent;margin:0;}.react-datepicker__time-list{", (0, _global_styling.logicalCSS)('height', '204px'), ";}.react-datepicker__time-list-item{", (0, _global_styling.logicalCSS)('min-width', '112px'), " font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";text-align:start;}}");
};