"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridFullScreenStyles = void 0;
var _css = require("@emotion/css");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridFullScreenStyles = exports.euiDataGridFullScreenStyles = function euiDataGridFullScreenStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var fullScreenZIndex = Number(euiTheme.levels.header) - 1;
  return {
    'euiDataGrid--fullScreen': /*#__PURE__*/(0, _css.css)("z-index:", fullScreenZIndex, ";position:fixed;inset:0;background-color:", euiTheme.colors.emptyShade, ";;label:euiDataGrid--fullScreen;"),
    // This is a vanilla className applied to the <body> when fullscreen is enabled.
    // It removes extra scrollbars + tweaks components to account for fixed headers
    euiDataGrid__restrictBody: /*#__PURE__*/(0, _css.css)((0, _global_styling.logicalCSS)('height', '100vh'), " overflow:hidden;.euiHeader[data-fixed-header]{z-index:", fullScreenZIndex - 1, "!important;}.euiOverlayMask[data-relative-to-header='below']{", (0, _global_styling.logicalCSS)('top', '0'), ";}.euiFlyout{", (0, _global_styling.logicalCSS)('top', '0'), " ", (0, _global_styling.logicalCSS)('height', '100%'), ";};label:euiDataGrid__restrictBody;")
  };
};