"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiColorPickerSwatchStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "164u3xw-tooltip",
  styles: "display:inline-flex;label:tooltip;"
} : {
  name: "164u3xw-tooltip",
  styles: "display:inline-flex;label:tooltip;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiColorPickerSwatchStyles = exports.euiColorPickerSwatchStyles = function euiColorPickerSwatchStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiColorPickerSwatch: /*#__PURE__*/(0, _react.css)("display:inline-block;", (0, _global_styling.logicalSizeCSS)(euiTheme.size.l), " border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.medium, function (x) {
      return x / 2;
    }), ";", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          border: ".concat(euiTheme.border.width.thin, " solid\n            ").concat(euiTheme.colors.borderBaseFormsColorSwatch, ";\n          box-shadow: inset 0 0 0 ").concat(euiTheme.border.width.thin, "\n            ").concat((0, _services.transparentize)(euiTheme.colors.emptyShade, 0.05), ";\n        "),
      preferred: "border: ".concat(euiTheme.border.thin, ";"),
      forced: (0, _high_contrast.preventForcedColors)(euiThemeContext)
    }), " cursor:pointer;&:disabled{cursor:default;}&:focus{", (0, _global_styling.euiOutline)(euiThemeContext, 'center'), ";};label:euiColorPickerSwatch;"),
    tooltip: _ref
  };
};