"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiColorPaletteDisplayStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _high_contrast = require("../../../global_styling/functions/high_contrast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiColorPaletteDisplayStyles = exports.euiColorPaletteDisplayStyles = function euiColorPaletteDisplayStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var border = highContrastMode ? euiTheme.border.thin : // Border is a pseudo element with transparency
  "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.borderBaseFormsColorSwatch);
  return {
    euiColorPaletteDisplay: /*#__PURE__*/(0, _react.css)("position:relative;display:flex;flex-direction:row;overflow:hidden;", (0, _high_contrast.preventForcedColors)(euiThemeContext), " &::after{content:'';position:absolute;inset:0;pointer-events:none;border:", border, ";border-radius:inherit;};label:euiColorPaletteDisplay;"),
    // Sizes
    xs: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.xs), " border-radius:", euiTheme.size.xs, ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.s), " border-radius:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.base), " border-radius:", euiTheme.size.base, ";;label:m;")
  };
};