"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _accordion = require("../../accordion");
var _collapsible_nav_item = require("./collapsible_nav_item");
var _collapsible_nav_link = require("./collapsible_nav_link");
var _collapsible_nav_accordion = require("./collapsible_nav_accordion.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "className", "items", "isSubItem", "isSelected", "accordionProps", "buttonContent", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/**
 * Internal nav accordion component.
 *
 * Renders children as either a nav link or any number/nesting of more nav accordions.
 * Triggering the open/closed state is handled only by the accordion `arrow` for
 * UX consistency, as accordion/nav titles can be their own links to pages.
 */
var EuiCollapsibleNavAccordion = exports.EuiCollapsibleNavAccordion = function EuiCollapsibleNavAccordion(_ref) {
  var _accordionProps$arrow;
  var id = _ref.id,
    className = _ref.className,
    items = _ref.items,
    isSubItem = _ref.isSubItem,
    isSelected = _ref.isSelected,
    accordionProps = _ref.accordionProps,
    buttonContent = _ref.buttonContent,
    _children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsibleNavAccordion', className);
  var groupID = (0, _services.useGeneratedHtmlId)({
    conditionalId: id
  });
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_accordion.euiCollapsibleNavAccordionStyles);
  var cssStyles = [styles.euiCollapsibleNavAccordion, isSubItem ? styles.isSubItem : styles.isTopItem, isSelected && styles.isSelected, accordionProps === null || accordionProps === void 0 ? void 0 : accordionProps.css];
  return (0, _react2.jsx)(_accordion.EuiAccordion, _extends({
    id: groupID,
    className: classes,
    initialIsOpen: isSelected,
    buttonContent: (0, _react2.jsx)(_collapsible_nav_link.EuiCollapsibleNavLink, {
      isSelected: isSelected,
      isSubItem: isSubItem,
      isInteractive: false
    }, buttonContent),
    arrowDisplay: "right"
  }, rest, accordionProps, {
    css: cssStyles,
    arrowProps: _objectSpread(_objectSpread({
      iconSize: 's'
    }, accordionProps === null || accordionProps === void 0 ? void 0 : accordionProps.arrowProps), {}, {
      css: [styles.euiCollapsibleNavAccordion__arrow, accordionProps === null || accordionProps === void 0 || (_accordionProps$arrow = accordionProps.arrowProps) === null || _accordionProps$arrow === void 0 ? void 0 : _accordionProps$arrow.css]
    })
  }), (0, _react2.jsx)(_collapsible_nav_item.EuiCollapsibleNavSubItems, {
    items: items,
    isSubItem: isSubItem,
    className: "euiCollapsibleNavAccordion__children"
  }));
};
EuiCollapsibleNavAccordion.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Highlights whether an item is currently selected, e.g.
       * if the user is on the same page as the nav link
       */
  isSelected: _propTypes.default.bool,
  /**
     * Determines whether the item should render as a top-level nav item
     * or a nested nav subitem. Set internally by EUI
     */
  isSubItem: _propTypes.default.bool,
  buttonContent: _propTypes.default.node.isRequired
};