"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCheckableCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _tabbable = require("tabbable");
var _form = require("../../form");
var _panel = require("../../panel");
var _services = require("../../../services");
var _checkable_card = require("./checkable_card.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "css", "checkableType", "label", "labelProps", "checked", "disabled", "hasShadow", "hasBorder"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// if `checkableType` is left out or set to 'radio', use EuiRadioProps
// if `checkableType` is set to 'checkbox', use EuiCheckboxProps
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiCheckableCard = exports.EuiCheckableCard = function EuiCheckableCard(_ref) {
  var children = _ref.children,
    className = _ref.className,
    css = _ref.css,
    _ref$checkableType = _ref.checkableType,
    checkableType = _ref$checkableType === void 0 ? 'radio' : _ref$checkableType,
    label = _ref.label,
    labelProps = _ref.labelProps,
    checked = _ref.checked,
    disabled = _ref.disabled,
    hasShadow = _ref.hasShadow,
    _ref$hasBorder = _ref.hasBorder,
    hasBorder = _ref$hasBorder === void 0 ? true : _ref$hasBorder,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiThemeContext = (0, _services.useEuiTheme)();
  var styles = (0, _checkable_card.euiCheckableCardStyles)(euiThemeContext);
  var baseStyles = [styles.euiCheckableCard, checked && !disabled && styles.isChecked, css];
  var labelStyles = [styles.label.euiCheckableCard__label, disabled && styles.label.isDisabled];
  var childStyles = [styles.euiCheckableCard__children];
  var id = rest.id;
  var labelEl = (0, _react.useRef)(null);
  var inputEl = (0, _react.useRef)(null);
  var childrenWrapperEl = (0, _react.useRef)(null);
  var classes = (0, _classnames.default)('euiCheckableCard', className);
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    hasInteractiveChildren = _useState2[0],
    setHasInteractiveChildren = _useState2[1];
  (0, _react.useEffect)(function () {
    var interactiveElements = childrenWrapperEl.current ? (0, _tabbable.tabbable)(childrenWrapperEl.current) : [];
    setHasInteractiveChildren(interactiveElements.length > 0);
  }, [children, childrenWrapperEl]);
  var checkableElement;
  if (checkableType === 'radio') {
    checkableElement = (0, _react2.jsx)(_form.EuiRadio, _extends({
      checked: checked,
      disabled: disabled
    }, rest));
  } else {
    checkableElement = (0, _react2.jsx)(_form.EuiCheckbox, _extends({
      inputRef: inputEl,
      checked: checked,
      disabled: disabled
    }, rest));
  }
  var labelClasses = (0, _classnames.default)('euiCheckableCard__label');
  var onChangeAffordance = function onChangeAffordance(e) {
    if (!labelEl.current || e.target === inputEl.current) return;
    labelEl.current.click();
  };
  var onChildrenClick = function onChildrenClick() {
    var _labelEl$current;
    if (hasInteractiveChildren) return;
    (_labelEl$current = labelEl.current) === null || _labelEl$current === void 0 || _labelEl$current.click();
  };
  return (0, _react2.jsx)(_panel.EuiSplitPanel.Outer, {
    responsive: false,
    hasShadow: hasShadow,
    hasBorder: hasBorder,
    direction: "row",
    className: classes,
    css: baseStyles
  }, (0, _react2.jsx)(_panel.EuiSplitPanel.Inner, {
    // Bubbles up the change event when clicking on the whole div for extra affordance
    onClick: disabled ? undefined : onChangeAffordance,
    color: checked ? 'primary' : 'subdued',
    grow: false
  }, checkableElement), (0, _react2.jsx)(_panel.EuiSplitPanel.Inner, null, (0, _react2.jsx)("label", _extends({}, labelProps, {
    ref: labelEl,
    className: labelClasses,
    css: labelStyles,
    htmlFor: id,
    "aria-describedby": children ? "".concat(id, "-details") : undefined
  }), label), children && (0, _react2.jsx)("div", {
    ref: childrenWrapperEl,
    id: "".concat(id, "-details"),
    className: "euiCheckableCard__children",
    css: childStyles,
    onClick: disabled ? undefined : onChildrenClick,
    style: {
      cursor: !disabled && !hasInteractiveChildren ? 'pointer' : undefined
    }
  }, children)));
};
EuiCheckableCard.propTypes = {
  id: _propTypes.default.string.isRequired,
  label: _propTypes.default.node.isRequired,
  hasShadow: _propTypes.default.any,
  hasBorder: _propTypes.default.any
};