"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getResolvedBackgroundColorSelector = void 0;
const get_chart_theme_1 = require("./get_chart_theme");
const color_library_wrappers_1 = require("../../common/color_library_wrappers");
const colors_1 = require("../../common/colors");
const fill_text_color_1 = require("../../common/fill_text_color");
const create_selector_1 = require("../create_selector");
exports.getResolvedBackgroundColorSelector = (0, create_selector_1.createCustomCachedSelector)([get_chart_theme_1.getChartThemeSelector], ({ background: { fallbackColor, color = colors_1.Colors.Transparent.keyword } }) => {
    let backgroundRGBA = (0, color_library_wrappers_1.colorToRgba)(color);
    if (backgroundRGBA[3] < fill_text_color_1.TRANSPARENT_LIMIT) {
        backgroundRGBA = (0, color_library_wrappers_1.colorToRgba)(fallbackColor);
    }
    return (0, color_library_wrappers_1.RGBATupleToString)(backgroundRGBA);
});
//# sourceMappingURL=get_resolved_background_color.js.map