"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Settings = void 0;
exports.isMetricElementEvent = isMetricElementEvent;
exports.isPointerOutEvent = isPointerOutEvent;
exports.isPointerOverEvent = isPointerOverEvent;
const default_settings_spec_1 = require("./default_settings_spec");
const settings_types_1 = require("./settings_types");
const spec_factory_1 = require("../state/spec_factory");
const common_1 = require("../utils/common");
function isMetricElementEvent(e) {
    return 'type' in e && e.type === 'metricElementEvent';
}
const Settings = function (props) {
    const { defaults, overrides } = default_settings_spec_1.settingsBuildProps;
    (0, spec_factory_1.useSpecFactory)({ ...defaults, ...(0, common_1.stripUndefined)(props), ...overrides });
    return null;
};
exports.Settings = Settings;
function isPointerOutEvent(event) {
    return event?.type === settings_types_1.PointerEventType.Out;
}
function isPointerOverEvent(event) {
    return event?.type === settings_types_1.PointerEventType.Over;
}
//# sourceMappingURL=settings.js.map