"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useLegendColorPicker = void 0;
const react_1 = __importDefault(require("react"));
const color_1 = require("./color");
const useLegendColorPicker = ({ item: { color, isSeriesHidden, label, pointStyle, seriesIdentifiers }, colorPicker: ColorPickerRenderer, clearTemporaryColorsAction, setTemporaryColorAction, setPersistedColorAction, }) => {
    const [isOpen, setIsOpen] = react_1.default.useState(false);
    const colorRef = react_1.default.useRef(null);
    const shouldClearPersistedColor = react_1.default.useRef(false);
    const toggleIsOpen = () => {
        setIsOpen((prevIsOpen) => !prevIsOpen);
    };
    const handleColorClick = (changeable) => changeable
        ? (event) => {
            event.stopPropagation();
            toggleIsOpen();
        }
        : undefined;
    const handleColorPickerClose = () => {
        const seriesKeys = seriesIdentifiers.map(({ key }) => key);
        setPersistedColorAction({ keys: seriesKeys, color: shouldClearPersistedColor.current ? null : color });
        clearTemporaryColorsAction();
        requestAnimationFrame(() => colorRef.current?.focus());
        toggleIsOpen();
    };
    const handleColorPickerChange = (c) => {
        const seriesKeys = seriesIdentifiers.map(({ key }) => key);
        shouldClearPersistedColor.current = c === null;
        setTemporaryColorAction({ keys: seriesKeys, color: c });
    };
    const hasColorPicker = Boolean(ColorPickerRenderer);
    const renderItemColor = () => (react_1.default.createElement(color_1.Color, { ref: colorRef, color: color, seriesName: label, isSeriesHidden: isSeriesHidden, hasColorPicker: hasColorPicker, onClick: handleColorClick(hasColorPicker), pointStyle: pointStyle }));
    const renderColorPickerPopup = () => ColorPickerRenderer &&
        isOpen &&
        colorRef.current && (react_1.default.createElement(ColorPickerRenderer, { anchor: colorRef.current, color: color, onClose: handleColorPickerClose, onChange: handleColorPickerChange, seriesIdentifiers: seriesIdentifiers }));
    return { renderItemColor, renderColorPickerPopup };
};
exports.useLegendColorPicker = useLegendColorPicker;
//# sourceMappingURL=legend_color_picker.js.map