"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAxesStylesSelector = void 0;
const get_api_scale_configs_1 = require("./get_api_scale_configs");
const get_specs_1 = require("./get_specs");
const create_selector_1 = require("../../../../state/create_selector");
const get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
const get_settings_spec_1 = require("../../../../state/selectors/get_settings_spec");
const common_1 = require("../../../../utils/common");
const axis_type_utils_1 = require("../../utils/axis_type_utils");
const axis_utils_1 = require("../../utils/axis_utils");
const MULTILAYER_TIME_AXIS_STYLE = {
    tickLabel: {
        visible: true,
        padding: 0,
        rotation: 0,
        alignment: {
            vertical: common_1.Position.Bottom,
            horizontal: common_1.Position.Left,
        },
    },
    tickLine: {
        visible: true,
        size: 0,
        padding: 4,
    },
};
exports.getAxesStylesSelector = (0, create_selector_1.createCustomCachedSelector)([get_specs_1.getAxisSpecsSelector, get_chart_theme_1.getChartThemeSelector, get_api_scale_configs_1.getScaleConfigsFromSpecsSelector, get_settings_spec_1.getSettingsSpecSelector], (axesSpecs, { axes: sharedAxesStyle }, scaleConfigs, settingsSpec) => axesSpecs.reduce((axesStyles, axisSpec) => {
    const { id, position, style, gridLine } = axisSpec;
    let mergedStyle = null;
    if ((0, axis_utils_1.isMultilayerTimeAxis)(axisSpec, scaleConfigs.x.type, settingsSpec.rotation)) {
        mergedStyle = (0, common_1.mergePartial)(sharedAxesStyle, MULTILAYER_TIME_AXIS_STYLE);
    }
    if (style) {
        const gridStyle = gridLine && {
            gridLine: { [(0, axis_type_utils_1.isVerticalAxis)(position) ? 'vertical' : 'horizontal']: gridLine },
        };
        mergedStyle = (0, common_1.mergePartial)(mergedStyle ?? sharedAxesStyle, { ...style, ...gridStyle });
    }
    return axesStyles.set(id, mergedStyle);
}, new Map()));
//# sourceMappingURL=get_axis_styles.js.map