"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartSelectorsFactory = void 0;
const compute_chart_dimensions_1 = require("./selectors/compute_chart_dimensions");
const compute_legend_1 = require("./selectors/compute_legend");
const compute_series_domains_1 = require("./selectors/compute_series_domains");
const get_brush_area_1 = require("./selectors/get_brush_area");
const get_chart_type_description_1 = require("./selectors/get_chart_type_description");
const get_cursor_pointer_1 = require("./selectors/get_cursor_pointer");
const get_debug_state_1 = require("./selectors/get_debug_state");
const get_legend_item_extra_values_1 = require("./selectors/get_legend_item_extra_values");
const get_specs_1 = require("./selectors/get_specs");
const get_tooltip_anchor_position_1 = require("./selectors/get_tooltip_anchor_position");
const get_tooltip_values_highlighted_geoms_1 = require("./selectors/get_tooltip_values_highlighted_geoms");
const is_brush_available_1 = require("./selectors/is_brush_available");
const is_chart_empty_1 = require("./selectors/is_chart_empty");
const is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
const on_brush_end_caller_1 = require("./selectors/on_brush_end_caller");
const on_click_caller_1 = require("./selectors/on_click_caller");
const on_element_out_caller_1 = require("./selectors/on_element_out_caller");
const on_element_over_caller_1 = require("./selectors/on_element_over_caller");
const on_pointer_move_caller_1 = require("./selectors/on_pointer_move_caller");
const on_projection_area_caller_1 = require("./selectors/on_projection_area_caller");
const chart_selectors_1 = require("../../../state/chart_selectors");
const get_chart_container_dimensions_1 = require("../../../state/selectors/get_chart_container_dimensions");
const get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
const is_brushing_1 = require("../../../state/selectors/is_brushing");
exports.chartSelectorsFactory = (0, chart_selectors_1.createChartSelectorsFactory)({
    isInitialized: (state) => (0, get_specs_1.getSeriesSpecsSelector)(state).length > 0 ? get_internal_is_intialized_1.InitStatus.Initialized : get_internal_is_intialized_1.InitStatus.SpecNotInitialized,
    isBrushAvailable: is_brush_available_1.isBrushAvailableSelector,
    isBrushing: (globalState) => (0, is_brush_available_1.isBrushAvailableSelector)(globalState) && (0, is_brushing_1.isBrushingSelector)(globalState),
    isChartEmpty: is_chart_empty_1.isChartEmptySelector,
    getLegendItems: compute_legend_1.computeLegendSelector,
    getLegendExtraValues: get_legend_item_extra_values_1.getLegendItemExtraValuesSelector,
    getPointerCursor: get_cursor_pointer_1.getPointerCursorSelector,
    isTooltipVisible: is_tooltip_visible_1.isTooltipVisibleSelector,
    getTooltipInfo: get_tooltip_values_highlighted_geoms_1.getTooltipInfoSelector,
    getTooltipAnchor: get_tooltip_anchor_position_1.getTooltipAnchorPositionSelector,
    getProjectionContainerArea: get_chart_container_dimensions_1.getChartContainerDimensionsSelector,
    getMainProjectionArea: (state) => (0, compute_chart_dimensions_1.computeChartDimensionsSelector)(state).chartDimensions,
    getBrushArea: get_brush_area_1.getBrushAreaSelector,
    getDebugState: get_debug_state_1.getDebugStateSelector,
    getChartTypeDescription: get_chart_type_description_1.getChartTypeDescriptionSelector,
    getSmallMultiplesDomains: compute_series_domains_1.computeSeriesDomainsSelector,
}, [
    on_click_caller_1.createOnClickCaller,
    on_element_over_caller_1.createOnElementOverCaller,
    on_element_out_caller_1.createOnElementOutCaller,
    on_brush_end_caller_1.createOnBrushEndCaller,
    on_pointer_move_caller_1.createOnPointerMoveCaller,
    on_projection_area_caller_1.createOnProjectionAreaCaller,
]);
//# sourceMappingURL=chart_selectors.js.map