"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecondaryMetric = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const badge_1 = require("./badge");
const SecondaryMetric = ({ value, label, badgeColor, labelPosition = 'before', style, ariaDescription, badgeBorderColor, icon, iconPosition, }) => {
    const hasLabel = !!label;
    const labelNode = hasLabel ? (react_1.default.createElement("span", { className: "echSecondaryMetric__label echSecondaryMetric__truncate" }, label)) : undefined;
    return (react_1.default.createElement("span", { className: "echSecondaryMetric", ...(style ? { style } : {}), ...(ariaDescription ? { 'aria-describedby': ariaDescription } : {}) },
        labelPosition === 'before' && labelNode,
        badgeColor ? (react_1.default.createElement(badge_1.Badge, { className: (0, classnames_1.default)('echSecondaryMetric__value', {
                'echSecondaryMetric__value--full': !hasLabel,
            }), value: value, backgroundColor: badgeColor, borderColor: badgeBorderColor, icon: icon, iconPosition: iconPosition })) : (react_1.default.createElement("span", { className: (0, classnames_1.default)('echSecondaryMetric__value', 'echSecondaryMetric__truncate', {
                'echSecondaryMetric__value--full': !hasLabel,
            }) }, value)),
        labelPosition === 'after' && labelNode));
};
exports.SecondaryMetric = SecondaryMetric;
//# sourceMappingURL=secondary_metric.js.map