"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartSelectorsFactory = void 0;
const compute_chart_dimensions_1 = require("./selectors/compute_chart_dimensions");
const compute_legend_1 = require("./selectors/compute_legend");
const get_brush_area_1 = require("./selectors/get_brush_area");
const get_cursor_pointer_1 = require("./selectors/get_cursor_pointer");
const get_debug_state_1 = require("./selectors/get_debug_state");
const get_heatmap_table_1 = require("./selectors/get_heatmap_table");
const get_legend_items_labels_1 = require("./selectors/get_legend_items_labels");
const get_tooltip_anchor_1 = require("./selectors/get_tooltip_anchor");
const is_brush_available_1 = require("./selectors/is_brush_available");
const is_empty_1 = require("./selectors/is_empty");
const is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
const on_brush_end_caller_1 = require("./selectors/on_brush_end_caller");
const on_element_click_caller_1 = require("./selectors/on_element_click_caller");
const on_element_out_caller_1 = require("./selectors/on_element_out_caller");
const on_element_over_caller_1 = require("./selectors/on_element_over_caller");
const on_pointer_update_caller_1 = require("./selectors/on_pointer_update_caller");
const tooltip_1 = require("./selectors/tooltip");
const chart_selectors_1 = require("../../../state/chart_selectors");
const get_chart_container_dimensions_1 = require("../../../state/selectors/get_chart_container_dimensions");
const get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
const is_brushing_1 = require("../../../state/selectors/is_brushing");
exports.chartSelectorsFactory = (0, chart_selectors_1.createChartSelectorsFactory)({
    isInitialized: () => get_internal_is_intialized_1.InitStatus.Initialized,
    isBrushAvailable: is_brush_available_1.isBrushAvailableSelector,
    isBrushing: is_brushing_1.isBrushingSelector,
    isChartEmpty: is_empty_1.isEmptySelector,
    getLegendItems: compute_legend_1.computeLegendSelector,
    getLegendItemsLabels: get_legend_items_labels_1.getLegendItemsLabelsSelector,
    getPointerCursor: get_cursor_pointer_1.getPointerCursorSelector,
    isTooltipVisible: is_tooltip_visible_1.isTooltipVisibleSelector,
    getTooltipInfo: tooltip_1.getTooltipInfoSelector,
    getTooltipAnchor: get_tooltip_anchor_1.getTooltipAnchorSelector,
    getProjectionContainerArea: get_chart_container_dimensions_1.getChartContainerDimensionsSelector,
    getMainProjectionArea: (state) => (0, compute_chart_dimensions_1.computeChartDimensionsSelector)(state).chartDimensions,
    getBrushArea: get_brush_area_1.getBrushAreaSelector,
    getDebugState: get_debug_state_1.getDebugStateSelector,
    getChartTypeDescription: () => 'Heatmap chart',
    getSmallMultiplesDomains: get_heatmap_table_1.getHeatmapTableSelector,
}, [
    on_element_click_caller_1.createOnElementClickCaller,
    on_element_over_caller_1.createOnElementOverCaller,
    on_element_out_caller_1.createOnElementOutCaller,
    on_brush_end_caller_1.createOnBrushEndCaller,
    on_pointer_update_caller_1.createOnPointerUpdateCaller,
]);
//# sourceMappingURL=chart_selectors.js.map