"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureDeepObject = ensureDeepObject;
// From https://github.com/elastic/kibana/blob/master/packages/kbn-config/src/raw/ensure_deep_object.ts
var separator = '.';
/**
 * Recursively traverses through the object's properties and expands ones with
 * dot-separated names into nested objects (eg. { a.b: 'c'} -> { a: { b: 'c' }).
 * @param obj Object to traverse through.
 * @returns Same object instance with expanded properties.
 */
function ensureDeepObject(obj) {
    if (obj == null || typeof obj !== 'object') {
        return obj;
    }
    if (Array.isArray(obj)) {
        return obj.map(function (item) { return ensureDeepObject(item); });
    }
    return Object.keys(obj).reduce(function (fullObject, propertyKey) {
        var propertyValue = obj[propertyKey];
        if (!propertyKey.includes(separator)) {
            fullObject[propertyKey] = ensureDeepObject(propertyValue);
        }
        else {
            walk(fullObject, propertyKey.split(separator), propertyValue);
        }
        return fullObject;
    }, {});
}
function walk(obj, keys, value) {
    var key = keys.shift();
    if (keys.length === 0) {
        obj[key] = value;
        return;
    }
    if (obj[key] === undefined) {
        obj[key] = {};
    }
    walk(obj[key], keys, ensureDeepObject(value));
}
//# sourceMappingURL=ensure_deep_object.js.map