"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var joi_1 = __importDefault(require("joi"));
var path_1 = __importDefault(require("path"));
var fs_1 = require("fs");
var boom_1 = __importDefault(require("@hapi/boom"));
var status_1 = require("../status");
var _1 = require(".");
var config_service_1 = require("../config/config_service");
function emsLandingConfigHandler(request, h) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, basePath, appPaths, configPath, data, configJson, emsConfig, error_1;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _b.trys.push([0, 2, , 3]);
                    _a = h.context.config, basePath = _a.basePath, appPaths = _a.appPaths;
                    configPath = path_1.default.join(appPaths.ems, '/ems-landing-page/config.json');
                    return [4 /*yield*/, fs_1.promises.readFile(configPath)];
                case 1:
                    data = _b.sent();
                    configJson = JSON.parse(data.toString());
                    emsConfig = configJson.SUPPORTED_EMS;
                    emsConfig.manifest.production.emsFileApiUrl = basePath + '/file';
                    emsConfig.manifest.production.emsTileApiUrl = basePath + '/tile';
                    return [2 /*return*/, configJson];
                case 2:
                    error_1 = _b.sent();
                    request.server.log(['error', 'ems-landing-page'], {
                        error: error_1,
                        message: 'Error returing EMS Landing Page config',
                    });
                    return [2 /*return*/, boom_1.default.badImplementation(error_1)];
                case 3: return [2 /*return*/];
            }
        });
    });
}
function fontHandler(request, h) {
    return __awaiter(this, void 0, void 0, function () {
        var emsPath, _a, fontStack, range, fontsDir, fontPath, e_1, lastStack, lastFontPath, error_2, fallbackFontStack, error_3;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _b.trys.push([0, 10, , 11]);
                    emsPath = h.context.config.appPaths.ems;
                    _a = request.params, fontStack = _a.fontStack, range = _a.range;
                    fontsDir = path_1.default.join(emsPath, 'tile', 'fonts');
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 3, , 9]);
                    fontPath = path_1.default.join(fontsDir, fontStack, range + '.pbf');
                    return [4 /*yield*/, fs_1.promises.access(fontPath, fs_1.constants.R_OK)];
                case 2:
                    _b.sent();
                    return [2 /*return*/, h.file(fontPath)];
                case 3:
                    e_1 = _b.sent();
                    lastStack = fontStack.split(',').pop();
                    lastFontPath = path_1.default.join(fontsDir, lastStack, range + '.pbf');
                    _b.label = 4;
                case 4:
                    _b.trys.push([4, 6, , 8]);
                    return [4 /*yield*/, fs_1.promises.access(lastFontPath, fs_1.constants.R_OK)];
                case 5:
                    _b.sent();
                    return [2 /*return*/, h.file(lastFontPath)];
                case 6:
                    error_2 = _b.sent();
                    fallbackFontStack = path_1.default.join(fontsDir, config_service_1.Constants.DEFAULT_FONT_STACK, range + '.pbf');
                    return [4 /*yield*/, fs_1.promises.access(fallbackFontStack, fs_1.constants.R_OK)];
                case 7:
                    _b.sent();
                    return [2 /*return*/, h.file(fallbackFontStack)];
                case 8: return [3 /*break*/, 9];
                case 9: return [3 /*break*/, 11];
                case 10:
                    error_3 = _b.sent();
                    request.server.log(['debug', 'fonts'], {
                        error: error_3,
                        message: 'Error returning a font',
                    });
                    return [2 /*return*/, boom_1.default.notFound('Font not found', error_3)];
                case 11: return [2 /*return*/];
            }
        });
    });
}
function tileManifestHandler(request, h) {
    return __awaiter(this, void 0, void 0, function () {
        var emsPath, manifestPath, data, error_4;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    emsPath = h.context.config.appPaths.ems;
                    manifestPath = path_1.default.join(emsPath, 'tile', 'manifest');
                    return [4 /*yield*/, fs_1.promises.readFile(manifestPath)];
                case 1:
                    data = _a.sent();
                    return [2 /*return*/, data];
                case 2:
                    error_4 = _a.sent();
                    request.server.log(['error', 'tile', 'file'], {
                        error: error_4,
                        message: 'Error accessing tile manifest',
                    });
                    return [2 /*return*/, boom_1.default.badImplementation(error_4)];
                case 3: return [2 /*return*/];
            }
        });
    });
}
function tileServiceHandler(request, h) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, z, x, y, tileService, _b, data, headers_1, response_1, error_5;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    _c.trys.push([0, 2, , 3]);
                    _a = request.params, z = _a.z, x = _a.x, y = _a.y;
                    tileService = h.context.tileService;
                    return [4 /*yield*/, tileService.getTile(parseInt(z), parseInt(x), parseInt(y))];
                case 1:
                    _b = _c.sent(), data = _b.data, headers_1 = _b.headers;
                    response_1 = h.response(data);
                    if (headers_1) {
                        Object.keys(headers_1).forEach(function (k) {
                            response_1.header(k, headers_1[k]);
                        });
                    }
                    return [2 /*return*/, response_1];
                case 2:
                    error_5 = _c.sent();
                    if (error_5.message === 'Tile does not exist') {
                        return [2 /*return*/, boom_1.default.notFound(error_5.message)];
                    }
                    else {
                        request.server.log(['error', 'tiles'], { error: error_5 });
                        return [2 /*return*/, boom_1.default.badImplementation(error_5.message)];
                    }
                    return [3 /*break*/, 3];
                case 3: return [2 /*return*/];
            }
        });
    });
}
function tileStyleHandler(request, h) {
    return __awaiter(this, void 0, void 0, function () {
        var emsPath, styleBasePath, style, stylePath, data, styleJson, error_6;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    emsPath = h.context.config.appPaths.ems;
                    styleBasePath = path_1.default.join(emsPath, 'tile/styles');
                    style = request.params.style;
                    stylePath = path_1.default.normalize(path_1.default.join(styleBasePath, style, 'style-local.json'));
                    if (!stylePath.startsWith(styleBasePath)) {
                        throw new Error('Illegal style path');
                    }
                    return [4 /*yield*/, fs_1.promises.readFile(stylePath)];
                case 1:
                    data = _a.sent();
                    styleJson = JSON.parse(data.toString());
                    styleJson.sources.openmaptiles.url = '/data/v3.json';
                    styleJson.sprite = "/styles/".concat(style, "/sprite");
                    styleJson.glyphs = '/fonts/{fontstack}/{range}.pbf';
                    return [2 /*return*/, styleJson];
                case 2:
                    error_6 = _a.sent();
                    request.server.log(['warning', 'styles'], {
                        error: error_6,
                        message: 'Error returning a style',
                    });
                    return [2 /*return*/, boom_1.default.notFound('Style not found', error_6)];
                case 3: return [2 /*return*/];
            }
        });
    });
}
function statusHandler(request, h) {
    return __awaiter(this, void 0, void 0, function () {
        var EMS_PLATFORM, _a, tileService, licenseChecker, version, config, licenseIsValid, licenseError, clusterDetails, license, tsIsValid, tsMetadata, tsError, emsDir, metadata, statuses, error_7;
        var _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    _c.trys.push([0, 2, , 3]);
                    EMS_PLATFORM = process.env.EMS_PLATFORM || config_service_1.Constants.EMS_PLATFORM;
                    if (!(EMS_PLATFORM in status_1.emsPlatforms)) {
                        throw new Error('EMS_PLATFORM environment variable is not valid');
                    }
                    _a = h.context, tileService = _a.tileService, licenseChecker = _a.licenseChecker, version = _a.version, config = _a.config;
                    licenseIsValid = licenseChecker.isValid, licenseError = licenseChecker.error, clusterDetails = licenseChecker.clusterDetails;
                    license = (clusterDetails || {}).license;
                    tsIsValid = tileService.isValid, tsMetadata = tileService.metadata, tsError = tileService.error;
                    emsDir = config.appPaths.ems;
                    metadata = {
                        basePath: config.basePath,
                        platform: EMS_PLATFORM,
                    };
                    _b = {
                        License: (0, status_1.getLicenseStatus)({
                            licenseIsValid: licenseIsValid,
                            license: license,
                            licenseError: licenseError,
                        }),
                        Basemaps: (0, status_1.getTileServiceStatus)({ tsIsValid: tsIsValid, tsMetadata: tsMetadata, tsError: tsError })
                    };
                    return [4 /*yield*/, (0, status_1.getFileServiceStatus)(emsDir)];
                case 1:
                    statuses = (_b.Boundaries = _c.sent(),
                        _b);
                    return [2 /*return*/, (0, status_1.getServerStatus)(statuses, version, metadata)];
                case 2:
                    error_7 = _c.sent();
                    request.server.log(['error', 'metadata'], { error: error_7 });
                    return [2 /*return*/, boom_1.default.badImplementation(error_7.message)];
                case 3: return [2 /*return*/];
            }
        });
    });
}
function tileJsonHandler(request, h) {
    return __awaiter(this, void 0, void 0, function () {
        var tileService;
        return __generator(this, function (_a) {
            try {
                tileService = h.context.tileService;
                return [2 /*return*/, tileService.metadata];
            }
            catch (error) {
                request.server.log(['error', 'metadata'], { error: error });
                return [2 /*return*/, boom_1.default.badImplementation(error.message)];
            }
            return [2 /*return*/];
        });
    });
}
exports.default = {
    name: 'ems-routes-plugin',
    version: '1.0.0',
    register: function (server, options) {
        var _this = this;
        server.bind(options);
        // EMS Status
        server.route({
            method: 'GET',
            path: '/status',
            handler: statusHandler,
        });
        server.route({
            method: 'GET',
            path: '/tile/data/v3/{z}/{x}/{y}.pbf',
            handler: tileServiceHandler,
            options: {
                pre: [_1.licenseCheckPre],
                validate: {
                    params: function (value, _) { return __awaiter(_this, void 0, void 0, function () {
                        var error;
                        return __generator(this, function (_a) {
                            error = joi_1.default.object({
                                z: joi_1.default.number().integer(),
                                x: joi_1.default.number().integer(),
                                y: joi_1.default.number().integer(),
                            }).validate(value).error;
                            if (error) {
                                throw new Error('Error validating tile params');
                            }
                            return [2 /*return*/];
                        });
                    }); },
                },
            },
        });
        server.route({
            method: 'GET',
            path: '/tile/styles/{style}/style.json',
            handler: tileStyleHandler,
            options: { pre: [_1.licenseCheckPre] },
        });
        server.route({
            method: 'GET',
            path: '/tile/{param*}',
            handler: {
                directory: {
                    path: 'tile/',
                },
            },
            options: { pre: [_1.licenseCheckPre] },
        });
        server.route({
            method: 'GET',
            path: '/tile/v{emsVersion}/manifest',
            handler: tileManifestHandler,
            options: {
                pre: [_1.licenseCheckPre],
                validate: {
                    params: function (value, _) { return __awaiter(_this, void 0, void 0, function () {
                        var error;
                        return __generator(this, function (_a) {
                            error = joi_1.default.object({
                                emsVersion: joi_1.default.number(),
                            }).validate(value).error;
                            if (error) {
                                throw new Error('Error validating tile manifest version');
                            }
                            return [2 /*return*/];
                        });
                    }); },
                },
            },
        });
        server.route({
            method: 'GET',
            path: '/tile/fonts/{fontStack}/{range}.pbf',
            handler: fontHandler,
            options: { pre: [_1.licenseCheckPre] },
        });
        // TileJSON endpoint
        server.route({
            method: 'GET',
            path: '/tile/data/v3.json',
            handler: tileJsonHandler,
            options: { pre: [_1.licenseCheckPre] },
        });
        // EMS file service (manifest and geojson files)
        server.route({
            method: 'GET',
            path: '/file/{param*}',
            handler: {
                directory: {
                    path: 'file',
                },
            },
            options: { pre: [_1.licenseCheckPre] },
        });
        // EMS Landing Page dynamic config API urls
        server.route({
            method: 'GET',
            path: '/maps/config.json',
            handler: emsLandingConfigHandler,
            options: { pre: [_1.licenseCheckPre] },
        });
    },
};
//# sourceMappingURL=routes.js.map