"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// inspired by https://github.com/elastic/kibana/blob/master/tasks/licenses_csv_report.js
var yargs_1 = __importDefault(require("yargs"));
var fs_1 = require("fs");
var path_1 = require("path");
var installed_packages_1 = require("./installed_packages");
var helpers_1 = require("yargs/helpers");
var lodash_1 = require("lodash");
var config_1 = require("./config");
var flags = (0, yargs_1.default)((0, helpers_1.hideBin)(process.argv))
    .option('csv', {
    type: 'string',
    demandOption: true,
    describe: 'Write csv report to file',
})
    .option('dev', {
    type: 'boolean',
    default: false,
    describe: 'Include development dependencies',
})
    .help().argv;
var allDoubleQuoteRE = /"/g;
function escapeValue(value) {
    if ((0, lodash_1.isNull)(value)) {
        return;
    }
    return "\"".concat(value.replace(allDoubleQuoteRE, '""'), "\"");
}
function formatCsvValues(fields, values) {
    return fields
        .map(function (field) {
        var value = values[field];
        if ((0, lodash_1.isNull)(value) || (0, lodash_1.isUndefined)(value)) {
            return null;
        }
        return value.toString();
    })
        .map(escapeValue)
        .join(',');
}
function formatPackage(headers, pkg) {
    var data = {
        name: pkg.name,
        version: pkg.version,
        url: pkg.repository || "https://www.npmjs.com/package/".concat(pkg.name),
        license: pkg.licenses.join(','),
        sourceURL: pkg.sourceURL,
    };
    return formatCsvValues(headers, data);
}
function getPackagesCsv(headers, directories, includeDev) {
    return __awaiter(this, void 0, void 0, function () {
        var all_packages, pkgs, pkgToId, _a, _b, pkg, id;
        var e_1, _c;
        var _this = this;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0: return [4 /*yield*/, Promise.all(directories.map(function (directory) { return __awaiter(_this, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, (0, installed_packages_1.getInstalledPackages)({
                                        directory: directory,
                                        licenseOverrides: config_1.LICENSE_OVERRIDES,
                                        includeDev: includeDev,
                                    })];
                                case 1: return [2 /*return*/, _a.sent()];
                            }
                        });
                    }); }))];
                case 1:
                    all_packages = _d.sent();
                    pkgs = {};
                    pkgToId = function (pkg) { return "".concat(pkg.name, "-").concat(pkg.version); };
                    try {
                        for (_a = __values(all_packages.flat()), _b = _a.next(); !_b.done; _b = _a.next()) {
                            pkg = _b.value;
                            id = pkgToId(pkg);
                            if (!(id in pkgs)) {
                                pkgs[id] = pkg;
                            }
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    // Return the packages as a sorted CSV
                    return [2 /*return*/, Object.values(pkgs)
                            .map(function (pkg) {
                            return formatPackage(headers, pkg);
                        })
                            .sort(function (a, b) { return a.replace(/@/, '').localeCompare(b.replace(/@/, '')); })
                            .join('\n')];
            }
        });
    });
}
(function () { return __awaiter(void 0, void 0, void 0, function () {
    var headers, base_csv, file, server_root, frontpage_root, dependencies, final_csv, err_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                headers = ['name', 'version', 'url', 'license', 'sourceURL'];
                _a.label = 1;
            case 1:
                _a.trys.push([1, 5, , 6]);
                base_csv = [
                    {
                        name: 'Node.js',
                        version: process.versions.node,
                        repository: 'https://nodejs.org',
                        licenses: ['MIT'],
                    },
                    {
                        name: 'Red Hat Universal Base Image minimal',
                        version: '9',
                        repository: 'https://catalog.redhat.com/software/containers/ubi9/ubi-minimal/615bd9b4075b022acc111bf5',
                        licenses: [
                            'Custom;https://www.redhat.com/licenses/EULA_Red_Hat_Universal_Base_Image_English_20190422.pdf',
                        ],
                        sourceURL: 'docker://registry.access.redhat.com/ubi9/ubi-minimal:9.4-1227-source',
                    },
                ]
                    .map(function (pkg) {
                    return formatPackage(headers, pkg);
                })
                    .join('\n');
                if (!('csv' in flags)) {
                    throw new Error('csv is missing');
                }
                file = (0, path_1.normalize)(flags.csv);
                server_root = (0, path_1.resolve)(__dirname, '../..');
                frontpage_root = (0, path_1.resolve)(__dirname, '../../components/frontpage');
                if (!(file && (0, path_1.relative)(server_root, file).startsWith('../'))) return [3 /*break*/, 2];
                throw new Error("The dependencies report can't be generated outside this folder");
            case 2:
                if (!file) return [3 /*break*/, 4];
                return [4 /*yield*/, getPackagesCsv(headers, [server_root, frontpage_root], flags.dev)];
            case 3:
                dependencies = _a.sent();
                final_csv = "".concat(base_csv, "\n").concat(dependencies, "\n");
                (0, fs_1.writeFileSync)(file, "".concat(headers.join(','), "\n").concat(final_csv));
                _a.label = 4;
            case 4: return [3 /*break*/, 6];
            case 5:
                err_1 = _a.sent();
                throw err_1;
            case 6: return [2 /*return*/];
        }
    });
}); })();
//# sourceMappingURL=index.js.map