/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderFactory;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderIndex;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderCacheSettings;

public class SamlServiceProviderResolver
implements ClusterStateListener {
    private final Cache<String, CachedServiceProvider> cache;
    private final SamlServiceProviderIndex index;
    private final SamlServiceProviderFactory serviceProviderFactory;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public SamlServiceProviderResolver(Settings settings, SamlServiceProviderIndex index, SamlServiceProviderFactory serviceProviderFactory) {
        this.cache = ServiceProviderCacheSettings.buildCache(settings);
        this.index = index;
        this.serviceProviderFactory = serviceProviderFactory;
    }

    public void resolve(String entityId, ActionListener<SamlServiceProvider> listener) {
        this.index.findByEntityId(entityId, (ActionListener<Set<SamlServiceProviderIndex.DocumentSupplier>>)listener.delegateFailureAndWrap((delegate, documentSuppliers) -> {
            if (documentSuppliers.isEmpty()) {
                delegate.onResponse(null);
                return;
            }
            if (documentSuppliers.size() > 1) {
                delegate.onFailure((Exception)new IllegalStateException("Found multiple service providers with entity ID [" + entityId + "] - document ids [" + documentSuppliers.stream().map(s -> s.version.id).collect(Collectors.joining(",")) + "] in index [" + String.valueOf(this.index) + "]"));
                return;
            }
            SamlServiceProviderIndex.DocumentSupplier doc = (SamlServiceProviderIndex.DocumentSupplier)Iterables.get((Iterable)documentSuppliers, (int)0);
            CachedServiceProvider cached = (CachedServiceProvider)this.cache.get((Object)entityId);
            if (cached != null && cached.documentVersion.equals(doc.version)) {
                delegate.onResponse((Object)cached.serviceProvider);
            } else {
                this.populateCacheAndReturn(entityId, doc, (ActionListener<SamlServiceProvider>)delegate);
            }
        }));
    }

    private void populateCacheAndReturn(String entityId, SamlServiceProviderIndex.DocumentSupplier doc, ActionListener<SamlServiceProvider> listener) {
        SamlServiceProvider serviceProvider = this.serviceProviderFactory.buildServiceProvider(doc.document.get());
        CachedServiceProvider cacheEntry = new CachedServiceProvider(this, entityId, doc.version, serviceProvider);
        this.cache.put((Object)entityId, (Object)cacheEntry);
        listener.onResponse((Object)serviceProvider);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        Index currentIndex;
        Index previousIndex = this.index.getIndex(event.previousState());
        if (!Objects.equals(previousIndex, currentIndex = this.index.getIndex(event.state()))) {
            this.logger.info("Index has changed [{}] => [{}], clearing cache", (Object)previousIndex, (Object)currentIndex);
            this.cache.invalidateAll();
        }
    }

    private class CachedServiceProvider {
        private final String entityId;
        private final SamlServiceProviderIndex.DocumentVersion documentVersion;
        private final SamlServiceProvider serviceProvider;

        private CachedServiceProvider(SamlServiceProviderResolver samlServiceProviderResolver, String entityId, SamlServiceProviderIndex.DocumentVersion documentVersion, SamlServiceProvider serviceProvider) {
            this.entityId = entityId;
            this.documentVersion = documentVersion;
            this.serviceProvider = serviceProvider;
        }
    }
}

