/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.spi;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class WhitelistClassBinding {
    public final String origin;
    public final String targetJavaClassName;
    public final String methodName;
    public final String returnCanonicalTypeName;
    public final List<String> canonicalTypeNameParameters;
    public final Map<Class<?>, Object> painlessAnnotations;

    public WhitelistClassBinding(String origin, String targetJavaClassName, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters, List<Object> painlessAnnotations) {
        this.origin = Objects.requireNonNull(origin);
        this.targetJavaClassName = Objects.requireNonNull(targetJavaClassName);
        this.methodName = Objects.requireNonNull(methodName);
        this.returnCanonicalTypeName = Objects.requireNonNull(returnCanonicalTypeName);
        this.canonicalTypeNameParameters = List.copyOf(canonicalTypeNameParameters);
        this.painlessAnnotations = painlessAnnotations.stream().collect(Collectors.toUnmodifiableMap(Object::getClass, Function.identity()));
    }
}

