/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.grok.GrokCaptureConfig;
import org.joni.Region;

public interface GrokCaptureExtracter {
    public void extract(byte[] var1, int var2, Region var3);

    public static class MapExtracter
    implements GrokCaptureExtracter {
        private final Map<String, Object> result;
        private final List<GrokCaptureExtracter> fieldExtracters;

        MapExtracter(List<GrokCaptureConfig> captureConfig, Function<GrokCaptureConfig, Function<Consumer<Object>, GrokCaptureExtracter>> getExtracter) {
            this.result = captureConfig.isEmpty() ? Collections.emptyMap() : new LinkedHashMap();
            this.fieldExtracters = new ArrayList<GrokCaptureExtracter>(captureConfig.size());
            for (GrokCaptureConfig config : captureConfig) {
                this.fieldExtracters.add(getExtracter.apply(config).apply(value -> {
                    String key = config.name();
                    if (this.result.containsKey(key)) {
                        Object patt0$temp = this.result.get(key);
                        if (patt0$temp instanceof List) {
                            List values = (List)patt0$temp;
                            ((ArrayList)values).add(value);
                        } else {
                            ArrayList<Object> values = new ArrayList<Object>();
                            values.add(this.result.get(key));
                            values.add(value);
                            this.result.put(key, values);
                        }
                    } else {
                        this.result.put(key, value);
                    }
                }));
            }
        }

        @Override
        public void extract(byte[] utf8Bytes, int offset, Region region) {
            this.fieldExtracters.forEach(extracter -> extracter.extract(utf8Bytes, offset, region));
        }

        Map<String, Object> result() {
            return this.result;
        }
    }

    public record Range(Object match, int offset, int length) {
    }
}

