/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.runtime;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.lucene.spatial.CentroidCalculator;
import org.elasticsearch.lucene.spatial.Component2DVisitor;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.lucene.spatial.GeometryDocValueWriter;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;
import org.elasticsearch.script.GeometryFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.xpack.spatial.search.runtime.AbstractGeoShapeScriptFieldQuery;

public class GeoShapeScriptFieldGeoShapeQuery
extends AbstractGeoShapeScriptFieldQuery {
    private final Component2D component2D;
    private final LatLonGeometry[] geometries;
    private final ShapeRelation relation;
    private final GeoShapeIndexer indexer;

    public GeoShapeScriptFieldGeoShapeQuery(Script script, GeometryFieldScript.LeafFactory leafFactory, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
        super(script, leafFactory, fieldName);
        this.geometries = geometries;
        this.relation = relation;
        this.component2D = LatLonGeometry.create((LatLonGeometry[])geometries);
        this.indexer = new GeoShapeIndexer(Orientation.CCW, fieldName);
    }

    @Override
    protected boolean matches(Geometry geometry) {
        if (geometry == null) {
            return false;
        }
        GeometryDocValueReader reader = new GeometryDocValueReader();
        Component2DVisitor visitor = Component2DVisitor.getVisitor((Component2D)this.component2D, (ShapeField.QueryRelation)this.relation.getLuceneRelation(), (CoordinateEncoder)CoordinateEncoder.GEO);
        try {
            reader.reset(this.encodeGeometry(geometry));
            reader.visit((TriangleTreeVisitor)visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return visitor.matches();
    }

    private BytesRef encodeGeometry(Geometry geometry) throws IOException {
        CentroidCalculator centroidCalculator = new CentroidCalculator();
        centroidCalculator.add(geometry);
        return GeometryDocValueWriter.write((List)this.indexer.getIndexableFields(geometry), (CoordinateEncoder)CoordinateEncoder.GEO, (CentroidCalculator)centroidCalculator);
    }

    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
        return this.fieldName() + ":" + ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoShapeScriptFieldGeoShapeQuery that = (GeoShapeScriptFieldGeoShapeQuery)((Object)o);
        return this.relation == that.relation && Arrays.equals(this.geometries, that.geometries);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relation, Arrays.hashCode(this.geometries));
    }
}

