/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.util.function.LongConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public class GeoShapeCellIdSource
extends ValuesSource.Numeric {
    private final GeoShapeValuesSource valuesSource;
    private final GeoGridTiler encoder;
    private final LongConsumer circuitBreakerConsumer;

    public GeoShapeCellIdSource(GeoShapeValuesSource valuesSource, GeoGridTiler encoder, LongConsumer circuitBreakerConsumer) {
        this.valuesSource = valuesSource;
        this.encoder = encoder;
        this.circuitBreakerConsumer = circuitBreakerConsumer;
    }

    public boolean isFloatingPoint() {
        return false;
    }

    public SortedNumericDocValues longValues(LeafReaderContext ctx) {
        GeoShapeValues geoValues = (GeoShapeValues)this.valuesSource.shapeValues(ctx);
        ValuesSourceType vs = geoValues.valuesSourceType();
        if (GeoShapeValuesSourceType.instance() == vs) {
            return new GeoShapeCellValues(geoValues, this.encoder, this.circuitBreakerConsumer);
        }
        throw new IllegalArgumentException("unsupported geo type");
    }

    public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }
}

