/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.decoder.servlet;

import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestProxy;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.messaging.decoder.AbstractMessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.HttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpServletRequestMessageDecoder
extends AbstractMessageDecoder
implements HttpServletRequestMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(AbstractHttpServletRequestMessageDecoder.class);
    @Nullable
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;

    @Override
    @Nullable
    public HttpServletRequest getHttpServletRequest() {
        if (this.httpServletRequestSupplier == null) {
            return null;
        }
        return (HttpServletRequest)this.httpServletRequestSupplier.get();
    }

    @Nullable
    public NonnullSupplier<HttpServletRequest> getHttpServletRequestSupplier() {
        return this.httpServletRequestSupplier;
    }

    @Override
    @Deprecated(since="4.3", forRemoval=true)
    public void setHttpServletRequest(final @Nullable HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setHttpServletRequest", (String)this.getClass().getCanonicalName(), (String)"setHttpServletRequestSupplier");
        if (request != null && !(request instanceof ThreadLocalHttpServletRequestProxy)) {
            this.log.warn("Unsafe HttpServletRequest injected");
        }
        this.httpServletRequestSupplier = new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return request;
            }
        };
    }

    @Override
    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletRequestSupplier = requestSupplier;
    }

    @Override
    public void decode() throws MessageDecodingException {
        super.decode();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HTTP Servlet request cannot be null");
        }
    }
}

