/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.util.function.Consumer;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ir.BinaryImplNode;
import org.elasticsearch.painless.ir.ComparisonNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.InvokeCallNode;
import org.elasticsearch.painless.ir.UnaryMathNode;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.phase.IRExpressionModifyingVisitor;
import org.elasticsearch.painless.symbol.IRDecorations;
import org.elasticsearch.painless.symbol.ScriptScope;

public class DefaultEqualityMethodOptimizationPhase
extends IRExpressionModifyingVisitor {
    private final ScriptScope scriptScope;

    public DefaultEqualityMethodOptimizationPhase(ScriptScope scriptScope) {
        this.scriptScope = scriptScope;
    }

    @Override
    public void visitComparison(ComparisonNode irComparisonNode, Consumer<ExpressionNode> scope) {
        super.visitComparison(irComparisonNode, scope);
        Operation op = (Operation)((Object)irComparisonNode.getDecorationValue(IRDecorations.IRDOperation.class));
        if (op == Operation.EQ || op == Operation.NE) {
            ExpressionNode constantNode = null;
            ExpressionNode argumentNode = null;
            if (irComparisonNode.getLeftNode().getDecorationValue(IRDecorations.IRDConstant.class) instanceof String) {
                constantNode = irComparisonNode.getLeftNode();
                argumentNode = irComparisonNode.getRightNode();
            } else if (irComparisonNode.getRightNode().getDecorationValue(IRDecorations.IRDConstant.class) instanceof String) {
                constantNode = irComparisonNode.getRightNode();
                argumentNode = irComparisonNode.getLeftNode();
            }
            ExpressionNode node = null;
            Location loc = irComparisonNode.getLocation();
            if (constantNode != null) {
                InvokeCallNode invoke = new InvokeCallNode(loc);
                PainlessMethod method = this.scriptScope.getPainlessLookup().lookupPainlessMethod(String.class, false, "equals", 1);
                invoke.setMethod(method);
                invoke.setBox(String.class);
                invoke.addArgumentNode(argumentNode);
                invoke.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                BinaryImplNode call = new BinaryImplNode(loc);
                call.setLeftNode(constantNode);
                call.setRightNode(invoke);
                call.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                node = call;
            }
            if (node != null) {
                if (op == Operation.NE) {
                    UnaryMathNode not = new UnaryMathNode(loc);
                    not.setChildNode(node);
                    not.attachDecoration(new IRDecorations.IRDOperation(Operation.NOT));
                    not.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
                    node = not;
                }
                scope.accept(node);
            }
        }
    }
}

