/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.painless.action.PainlessContextTypeInfo;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class PainlessContextMethodInfo
implements Writeable,
ToXContentObject {
    public static final ParseField DECLARING = new ParseField("declaring", new String[0]);
    public static final ParseField NAME = new ParseField("name", new String[0]);
    public static final ParseField RTN = new ParseField("return", new String[0]);
    public static final ParseField PARAMETERS = new ParseField("parameters", new String[0]);
    private static final ConstructingObjectParser<PainlessContextMethodInfo, Void> PARSER = new ConstructingObjectParser(PainlessContextMethodInfo.class.getCanonicalName(), v -> new PainlessContextMethodInfo((String)v[0], (String)v[1], (String)v[2], (List)v[3]));
    private final String declaring;
    private final String name;
    private final String rtn;
    private final List<String> parameters;

    public PainlessContextMethodInfo(PainlessMethod painlessMethod) {
        this(painlessMethod.javaMethod().getDeclaringClass().getName(), painlessMethod.javaMethod().getName(), PainlessContextTypeInfo.getType(painlessMethod.returnType().getName()), painlessMethod.typeParameters().stream().map(c -> PainlessContextTypeInfo.getType(c.getName())).collect(Collectors.toList()));
    }

    public PainlessContextMethodInfo(String declaring, String name, String rtn, List<String> parameters) {
        this.declaring = Objects.requireNonNull(declaring);
        this.name = Objects.requireNonNull(name);
        this.rtn = Objects.requireNonNull(rtn);
        this.parameters = Collections.unmodifiableList(Objects.requireNonNull(parameters));
    }

    public PainlessContextMethodInfo(StreamInput in) throws IOException {
        this.declaring = in.readString();
        this.name = in.readString();
        this.rtn = in.readString();
        this.parameters = in.readCollectionAsImmutableList(StreamInput::readString);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.declaring);
        out.writeString(this.name);
        out.writeString(this.rtn);
        out.writeStringCollection(this.parameters);
    }

    public static PainlessContextMethodInfo fromXContent(XContentParser parser) {
        return (PainlessContextMethodInfo)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DECLARING.getPreferredName(), this.declaring);
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(RTN.getPreferredName(), this.rtn);
        builder.field(PARAMETERS.getPreferredName(), this.parameters);
        builder.endObject();
        return builder;
    }

    public String getSortValue() {
        return PainlessLookupUtility.buildPainlessMethodKey(this.name, this.parameters.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PainlessContextMethodInfo that = (PainlessContextMethodInfo)o;
        return Objects.equals(this.declaring, that.declaring) && Objects.equals(this.name, that.name) && Objects.equals(this.rtn, that.rtn) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.declaring, this.name, this.rtn, this.parameters);
    }

    public String toString() {
        return "PainlessContextMethodInfo{declaring='" + this.declaring + "', name='" + this.name + "', rtn='" + this.rtn + "', parameters=" + String.valueOf(this.parameters) + "}";
    }

    public String getDeclaring() {
        return this.declaring;
    }

    public String getName() {
        return this.name;
    }

    public String getRtn() {
        return this.rtn;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DECLARING);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), RTN);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), PARAMETERS);
    }
}

