/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.stats;

import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.stats.GetSecurityStatsAction;
import org.elasticsearch.xpack.core.security.action.stats.GetSecurityStatsNodesRequest;
import org.elasticsearch.xpack.security.SecurityFeatures;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestSecurityStatsAction
extends SecurityBaseRestHandler {
    private final Predicate<NodeFeature> clusterSupportsFeature;

    public RestSecurityStatsAction(Settings settings, XPackLicenseState licenseState, Predicate<NodeFeature> clusterSupportsFeature) {
        super(settings, licenseState);
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/stats"));
    }

    public String getName() {
        return "security_stats_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) {
        if (!this.clusterSupportsFeature.test(SecurityFeatures.SECURITY_STATS_ENDPOINT)) {
            throw new IllegalArgumentException("endpoint not supported on all nodes in the cluster");
        }
        GetSecurityStatsNodesRequest req = new GetSecurityStatsNodesRequest();
        return channel -> client.execute((ActionType)GetSecurityStatsAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
    }
}

